/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwa;

public enum OKPCurve {
    ED25519("Ed25519", "Ed25519", 32),
    ED448("Ed448", "Ed448", 57),
    X25519("X25519", "X25519", 32),
    X448("X448", "X448", 56);

    private final String crv;
    private final String jcaName;
    private final int keyLength;

    private OKPCurve(String crv, String jcaName, int keyLength) {
        this.crv = crv;
        this.jcaName = jcaName;
        this.keyLength = keyLength;
    }

    public String getCurve() {
        return this.crv;
    }

    public String getJCAName() {
        return this.jcaName;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public static OKPCurve fromCurve(String crv) {
        switch (crv) {
            case "Ed25519": {
                return ED25519;
            }
            case "Ed448": {
                return ED448;
            }
            case "X25519": {
                return X25519;
            }
            case "X448": {
                return X448;
            }
        }
        throw new IllegalArgumentException("Unknown curve " + crv);
    }
}

