/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwa;

import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwk.JWK;

public enum NoAlgorithm implements JWAAlgorithm<JWK>
{
    NONE("none", true, false, false),
    DIR("dir", false, true, false);

    private final String alg;
    private final boolean signature;
    private final boolean keyManagement;
    private final boolean encryption;

    private NoAlgorithm(String alg, boolean signature, boolean keyManagement, boolean encryption) {
        this.alg = alg;
        this.signature = signature;
        this.keyManagement = keyManagement;
        this.encryption = encryption;
    }

    @Override
    public String getAlgorithm() {
        return this.alg;
    }

    @Override
    public boolean isSignature() {
        return this.signature;
    }

    @Override
    public boolean isKeyManagement() {
        return this.keyManagement;
    }

    @Override
    public boolean isEncryption() {
        return this.encryption;
    }

    @Override
    public JWASigner createSigner(JWK jwk) throws JWAProcessingException {
        throw new JWAProcessingException("Algorithm does not support signature operations");
    }

    @Override
    public JWAKeyManager createKeyManager(JWK jwk) throws JWAProcessingException {
        throw new JWAProcessingException("Algorithm does not support key management operations");
    }

    @Override
    public JWACipher createCipher(JWK jwk) throws JWAProcessingException {
        throw new JWAProcessingException("Algorithm does not support encryption operations");
    }

    public static NoAlgorithm fromAlgorithm(String alg) throws IllegalArgumentException {
        switch (alg) {
            case "none": {
                return NONE;
            }
            case "dir": {
                return DIR;
            }
        }
        throw new IllegalArgumentException("Unknown algorithm " + alg);
    }
}

