/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwa;

import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;

public enum ECCurve {
    P_256("P-256", "secp256r1", 256),
    P_384("P-384", "secp384r1", 384),
    P_521("P-521", "secp521r1", 521),
    SECP256K1("secp256k1", "secp256k1", 256);

    private static ECParameterSpec P_256_EC_PARAMETER_SPEC;
    private static ECParameterSpec P_384_EC_PARAMETER_SPEC;
    private static ECParameterSpec P_521_EC_PARAMETER_SPEC;
    private static ECParameterSpec SECP256K1_EC_PARAMETER_SPEC;
    private final String crv;
    private final String jcaName;
    private final int fieldSize;
    private final int keyLength;
    private final int signatureLength;

    private ECCurve(String crv, String jcaName, int fieldSize) {
        this.crv = crv;
        this.jcaName = jcaName;
        this.fieldSize = fieldSize;
        this.keyLength = (this.fieldSize + 7) / 8;
        this.signatureLength = 2 * this.keyLength;
    }

    public String getCurve() {
        return this.crv;
    }

    public String getJCAName() {
        return this.jcaName;
    }

    public int getFieldSize() {
        return this.fieldSize;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public int getSignatureLength() {
        return this.signatureLength;
    }

    public ECParameterSpec getParameterSpec() throws JWAProcessingException, IllegalStateException {
        try {
            switch (this.crv) {
                case "P-256": {
                    if (P_256_EC_PARAMETER_SPEC == null) {
                        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
                        parameters.init(new ECGenParameterSpec("secp256r1"));
                        P_256_EC_PARAMETER_SPEC = parameters.getParameterSpec(ECParameterSpec.class);
                    }
                    return P_256_EC_PARAMETER_SPEC;
                }
                case "P-384": {
                    if (P_384_EC_PARAMETER_SPEC == null) {
                        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
                        parameters.init(new ECGenParameterSpec("secp384r1"));
                        P_384_EC_PARAMETER_SPEC = parameters.getParameterSpec(ECParameterSpec.class);
                    }
                    return P_384_EC_PARAMETER_SPEC;
                }
                case "P-521": {
                    if (P_521_EC_PARAMETER_SPEC == null) {
                        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
                        parameters.init(new ECGenParameterSpec("secp521r1"));
                        P_521_EC_PARAMETER_SPEC = parameters.getParameterSpec(ECParameterSpec.class);
                    }
                    return P_521_EC_PARAMETER_SPEC;
                }
                case "secp256k1": {
                    if (SECP256K1_EC_PARAMETER_SPEC == null) {
                        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
                        parameters.init(new ECGenParameterSpec("secp256k1"));
                        P_521_EC_PARAMETER_SPEC = parameters.getParameterSpec(ECParameterSpec.class);
                    }
                    return SECP256K1_EC_PARAMETER_SPEC;
                }
            }
            throw new JWAProcessingException("Unsupported curve: " + this.crv);
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new IllegalStateException("Error while creating EC key", e);
        }
    }

    public boolean isOnCurve(BigInteger x, BigInteger y) {
        EllipticCurve curve = this.getParameterSpec().getCurve();
        BigInteger a = curve.getA();
        BigInteger b = curve.getB();
        BigInteger p = ((ECFieldFp)curve.getField()).getP();
        BigInteger leftSide = y.pow(2).mod(p);
        BigInteger rightSide = x.pow(3).add(a.multiply(x)).add(b).mod(p);
        return leftSide.equals(rightSide);
    }

    public static ECCurve fromCurve(String crv) throws IllegalArgumentException {
        switch (crv) {
            case "P-256": {
                return P_256;
            }
            case "P-384": {
                return P_384;
            }
            case "P-521": {
                return P_521;
            }
            case "secp256k1": {
                return SECP256K1;
            }
        }
        throw new IllegalArgumentException("Unknown curve " + crv);
    }
}

