/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwa;

import io.inverno.mod.security.jose.internal.jwa.ECDH_ESKeyManager;
import io.inverno.mod.security.jose.internal.jwa.ECDH_ES_AESKWKeyManager;
import io.inverno.mod.security.jose.internal.jwa.ECSigner;
import io.inverno.mod.security.jose.jwa.ECCurve;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwk.ec.ECJWK;
import java.util.Objects;
import java.util.function.BiFunction;

public enum ECAlgorithm implements JWAAlgorithm<ECJWK>
{
    ES256("ES256", ECAlgorithm::createECSigner, null, null, "SHA256withECDSA", ECCurve.P_256),
    ES384("ES384", ECAlgorithm::createECSigner, null, null, "SHA384withECDSA", ECCurve.P_384),
    ES512("ES512", ECAlgorithm::createECSigner, null, null, "SHA512withECDSA", ECCurve.P_521),
    ES256K("ES256K", ECAlgorithm::createECSigner, null, null, "SHA256withECDSA", ECCurve.SECP256K1),
    ECDH_ES("ECDH-ES", null, ECAlgorithm::createECDH_ESKeyManager, null, null),
    ECDH_ES_A128KW("ECDH-ES+A128KW", null, ECAlgorithm::createECDH_ES_AESKWKeyManager, null, "A128KW"),
    ECDH_ES_A192KW("ECDH-ES+A192KW", null, ECAlgorithm::createECDH_ES_AESKWKeyManager, null, "A192KW"),
    ECDH_ES_A256KW("ECDH-ES+A256KW", null, ECAlgorithm::createECDH_ES_AESKWKeyManager, null, "A256KW");

    private final String alg;
    private final BiFunction<ECJWK, ECAlgorithm, JWASigner> signerFactory;
    private final BiFunction<ECJWK, ECAlgorithm, JWAKeyManager> keyManagerFactory;
    private final BiFunction<ECJWK, ECAlgorithm, JWACipher> cipherFactory;
    private final String jcaAlg;
    private final ECCurve curve;
    private final String keyWrappingAlgorithm;

    private ECAlgorithm(String alg, BiFunction<ECJWK, ECAlgorithm, JWASigner> signerFactory, BiFunction<ECJWK, ECAlgorithm, JWAKeyManager> keyManagerFactory, BiFunction<ECJWK, ECAlgorithm, JWACipher> cipherFactory, String keyWrappingAlgorithm) {
        this(alg, signerFactory, keyManagerFactory, cipherFactory, null, null, keyWrappingAlgorithm);
    }

    private ECAlgorithm(String alg, BiFunction<ECJWK, ECAlgorithm, JWASigner> signerFactory, BiFunction<ECJWK, ECAlgorithm, JWAKeyManager> keyManagerFactory, BiFunction<ECJWK, ECAlgorithm, JWACipher> cipherFactory, String jcaAlg, ECCurve curve) {
        this(alg, signerFactory, keyManagerFactory, cipherFactory, jcaAlg, curve, null);
    }

    private ECAlgorithm(String alg, BiFunction<ECJWK, ECAlgorithm, JWASigner> signerFactory, BiFunction<ECJWK, ECAlgorithm, JWAKeyManager> keyManagerFactory, BiFunction<ECJWK, ECAlgorithm, JWACipher> cipherFactory, String jcaAlg, ECCurve curve, String keyWrappingAlgorithm) {
        this.alg = alg;
        this.signerFactory = signerFactory;
        this.keyManagerFactory = keyManagerFactory;
        this.cipherFactory = cipherFactory;
        this.jcaAlg = jcaAlg;
        this.curve = curve;
        this.keyWrappingAlgorithm = keyWrappingAlgorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.alg;
    }

    @Override
    public boolean isSignature() {
        return this.signerFactory != null;
    }

    @Override
    public boolean isKeyManagement() {
        return this.keyManagerFactory != null;
    }

    @Override
    public boolean isEncryption() {
        return this.cipherFactory != null;
    }

    @Override
    public JWASigner createSigner(ECJWK jwk) throws JWAProcessingException {
        if (this.signerFactory == null) {
            throw new JWAProcessingException("Not a signature algorithm: " + this.alg);
        }
        return this.signerFactory.apply(jwk, this);
    }

    @Override
    public JWAKeyManager createKeyManager(ECJWK jwk) throws JWAProcessingException {
        if (this.keyManagerFactory == null) {
            throw new JWAProcessingException("Not a key management algorithm: " + this.alg);
        }
        return this.keyManagerFactory.apply(jwk, this);
    }

    @Override
    public JWACipher createCipher(ECJWK jwk) throws JWAProcessingException {
        if (this.cipherFactory == null) {
            throw new JWAProcessingException("Not an encryption algorithm: " + this.alg);
        }
        return this.cipherFactory.apply(jwk, this);
    }

    public String getJcaAlgorithm() {
        return this.jcaAlg;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public String getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    public static ECAlgorithm fromAlgorithm(String alg) throws IllegalArgumentException {
        switch (alg) {
            case "ES256": {
                return ES256;
            }
            case "ES384": {
                return ES384;
            }
            case "ES512": {
                return ES512;
            }
            case "ES256K": {
                return ES256K;
            }
            case "ECDH-ES": {
                return ECDH_ES;
            }
            case "ECDH-ES+A128KW": {
                return ECDH_ES_A128KW;
            }
            case "ECDH-ES+A192KW": {
                return ECDH_ES_A192KW;
            }
            case "ECDH-ES+A256KW": {
                return ECDH_ES_A256KW;
            }
        }
        throw new IllegalArgumentException("Unknown EC algorithm " + alg);
    }

    private static ECSigner createECSigner(ECJWK jwk, ECAlgorithm algorithm) throws JWAProcessingException {
        ECAlgorithm eCAlgorithm = algorithm;
        Objects.requireNonNull(eCAlgorithm);
        return eCAlgorithm.new InnerECSigner(jwk);
    }

    private static ECDH_ESKeyManager createECDH_ESKeyManager(ECJWK jwk, ECAlgorithm algorithm) throws JWAProcessingException {
        ECAlgorithm eCAlgorithm = algorithm;
        Objects.requireNonNull(eCAlgorithm);
        return eCAlgorithm.new InnerECDH_ESKeyManager(jwk);
    }

    private static ECDH_ES_AESKWKeyManager createECDH_ES_AESKWKeyManager(ECJWK jwk, ECAlgorithm algorithm) throws JWAProcessingException {
        ECAlgorithm eCAlgorithm = algorithm;
        Objects.requireNonNull(eCAlgorithm);
        return eCAlgorithm.new InnerECDH_ES_AESKWKeyManager(jwk);
    }

    private class InnerECSigner
    extends ECSigner {
        InnerECSigner(ECJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = ECAlgorithm.this;
            this.init();
        }
    }

    private class InnerECDH_ESKeyManager
    extends ECDH_ESKeyManager {
        InnerECDH_ESKeyManager(ECJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = ECAlgorithm.this;
            this.init();
        }
    }

    private class InnerECDH_ES_AESKWKeyManager
    extends ECDH_ES_AESKWKeyManager {
        InnerECDH_ES_AESKWKeyManager(ECJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = ECAlgorithm.this;
            this.init();
        }
    }
}

