/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.converter.GenericDataConversionService;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEReader;
import io.inverno.mod.security.jose.jwe.JWE;
import io.inverno.mod.security.jose.jwe.JWEBuildException;
import io.inverno.mod.security.jose.jwe.JWEHeader;
import io.inverno.mod.security.jose.jwe.JWEReadException;
import io.inverno.mod.security.jose.jwe.JWEZip;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jwt.JWTReadException;
import java.lang.reflect.Type;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class JWTEReader<A>
extends GenericJWEReader<A> {
    public JWTEReader(ObjectMapper mapper, GenericDataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys, List<JWEZip> zips) {
        super(mapper, dataConversionService, jwkService, type, keys, zips);
    }

    @Override
    public Mono<JWE<A>> read(String compact, String contentType) throws JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        return super.read(compact, "application/json");
    }

    @Override
    protected void checkHeader(JWEHeader header) throws JWTReadException, JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        super.checkHeader(header);
        String joseType = header.getType();
        if (joseType != null && !joseType.equals("JWT")) {
            throw new JWTReadException("Invalid JWT, type is not set to JWT: " + joseType);
        }
        String joseContentType = header.getContentType();
        if (joseContentType != null) {
            throw new JWTReadException("Invalid JWT, content type must not be set: " + joseContentType);
        }
    }
}

