/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.Init;
import io.inverno.mod.security.jose.JOSEObject;
import io.inverno.mod.security.jose.JOSEObjectReader;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.converter.GenericDataConversionService;
import io.inverno.mod.security.jose.internal.jwe.DeflateJWEZip;
import io.inverno.mod.security.jose.internal.jwt.JWTDataConversionService;
import io.inverno.mod.security.jose.internal.jwt.JWTEBuilder;
import io.inverno.mod.security.jose.internal.jwt.JWTEReader;
import io.inverno.mod.security.jose.internal.jwt.JWTSBuilder;
import io.inverno.mod.security.jose.internal.jwt.JWTSReader;
import io.inverno.mod.security.jose.jwe.JWEBuilder;
import io.inverno.mod.security.jose.jwe.JWEReader;
import io.inverno.mod.security.jose.jwe.JWEZip;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jws.JWSBuilder;
import io.inverno.mod.security.jose.jws.JWSReader;
import io.inverno.mod.security.jose.jwt.JWTClaimsSet;
import io.inverno.mod.security.jose.jwt.JWTReadException;
import io.inverno.mod.security.jose.jwt.JWTService;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.reactivestreams.Publisher;

@Bean(name="jwtService")
public class GenericJWTService
implements JWTService {
    private final ObjectMapper mapper;
    private final GenericDataConversionService dataConversionService;
    private final JWTDataConversionService jwtDataConversionService;
    private final JWKService jwkService;
    private final List<JWEZip> zips;

    public GenericJWTService(ObjectMapper mapper, GenericDataConversionService dataConversionService, JWKService jwkService) {
        this.mapper = mapper;
        this.dataConversionService = dataConversionService;
        this.jwtDataConversionService = new JWTDataConversionService(dataConversionService);
        this.jwkService = jwkService;
        this.zips = new LinkedList<JWEZip>();
    }

    @Init
    public void init() {
        this.dataConversionService.injectJWTService(this);
    }

    public void setJWEZips(List<JWEZip> zips) {
        this.zips.clear();
        JWEZip deflateZip = null;
        for (JWEZip zip : zips) {
            if (zip instanceof DeflateJWEZip) {
                deflateZip = zip;
                continue;
            }
            this.zips.add(zip);
        }
        if (deflateZip != null) {
            this.zips.add(deflateZip);
        }
    }

    private void checkJWTClaimsSetType(Type type) throws JOSEProcessingException {
        Type rawType;
        Objects.requireNonNull(type);
        if (type instanceof ParameterizedType ? !((rawType = ((ParameterizedType)type).getRawType()) instanceof Class) || !JWTClaimsSet.class.isAssignableFrom((Class)rawType) : !(type instanceof Class) || !JWTClaimsSet.class.isAssignableFrom((Class)type)) {
            throw new JOSEProcessingException("Invalid JWT Claims Set type: " + type.getTypeName());
        }
    }

    @Override
    public <T extends JWTClaimsSet> JWSBuilder<T, ?, ?> jwsBuilder(Type type, Publisher<? extends JWK> keys) throws JOSEProcessingException {
        this.checkJWTClaimsSetType(type);
        return new JWTSBuilder(this.mapper, this.jwtDataConversionService, this.jwkService, type, keys);
    }

    @Override
    public <T extends JWTClaimsSet> JWEBuilder<T, ?, ?> jweBuilder(Type type, Publisher<? extends JWK> keys) throws JOSEProcessingException {
        this.checkJWTClaimsSetType(type);
        return new JWTEBuilder(this.mapper, this.jwtDataConversionService, this.jwkService, type, keys, this.zips);
    }

    @Override
    public <T extends JWTClaimsSet> JWSReader<T, ?> jwsReader(Type type, Publisher<? extends JWK> keys) throws JOSEProcessingException {
        this.checkJWTClaimsSetType(type);
        return new JWTSReader(this.mapper, this.dataConversionService, this.jwkService, type, keys);
    }

    @Override
    public <T extends JWTClaimsSet> JWEReader<T, ?> jweReader(Type type, Publisher<? extends JWK> keys) throws JOSEProcessingException {
        this.checkJWTClaimsSetType(type);
        return new JWTEReader(this.mapper, this.dataConversionService, this.jwkService, type, keys, this.zips);
    }

    @Override
    public <T extends JWTClaimsSet> JOSEObjectReader<T, ?, ? extends JOSEObject<T, ?>, ?> readerFor(String compact, Type type, Publisher<? extends JWK> keys) throws JWTReadException, JOSEProcessingException {
        String[] splitCompact = compact.split("\\.");
        switch (splitCompact.length) {
            case 3: {
                return this.jwsReader(type, keys);
            }
            case 5: {
                return this.jweReader(type, keys);
            }
        }
        throw new JWTReadException("Invalid JWT object compact representation");
    }
}

