/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jws;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jws.GenericJWSHeader;
import io.inverno.mod.security.jose.internal.jws.GenericJWSPayload;
import io.inverno.mod.security.jose.internal.jws.GenericJWSReader;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jws.JWSReadException;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class SignatureJWSReader<A>
extends GenericJWSReader<A> {
    private final GenericJWSHeader jwsHeader;
    private final Mono<GenericJWSPayload<A>> jwsPayload;

    public SignatureJWSReader(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys, GenericJWSHeader jwsHeader, GenericJWSPayload<A> jwsPayload) {
        super(mapper, dataConversionService, jwkService, type, keys);
        this.jwsHeader = jwsHeader;
        this.jwsPayload = Mono.just(jwsPayload);
    }

    @Override
    protected GenericJWSHeader readJWSHeader(String encodedHeader) throws JWSReadException, JOSEObjectReadException, JOSEProcessingException {
        return this.jwsHeader;
    }

    @Override
    protected Mono<GenericJWSPayload<A>> readJWSPayload(String encodedPayload, Function<String, Mono<A>> overridingPayloadDecoder, String overridingContentType, GenericJWSHeader jwsHeader) throws JWSReadException, JOSEObjectReadException, JOSEProcessingException {
        return this.jwsPayload;
    }
}

