/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jws;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jws.GenericJWSBuilder;
import io.inverno.mod.security.jose.internal.jws.GenericJWSHeader;
import io.inverno.mod.security.jose.internal.jws.GenericJWSPayload;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jws.JWSBuildException;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class SignatureJWSBuilder<A>
extends GenericJWSBuilder<A> {
    private final GenericJWSHeader signatureProtectedJWSHeader;
    private final GenericJWSHeader jwsHeader;
    private final Mono<GenericJWSPayload<A>> jwsPayload;

    public SignatureJWSBuilder(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys, GenericJWSHeader signatureProtectedJWSHeader, GenericJWSHeader jwsHeader, GenericJWSPayload<A> jwsPayload) {
        super(mapper, dataConversionService, jwkService, type, keys);
        this.jwsHeader = jwsHeader;
        this.signatureProtectedJWSHeader = signatureProtectedJWSHeader;
        this.jwsPayload = Mono.just(jwsPayload);
    }

    @Override
    public GenericJWSBuilder<A> header(Consumer<GenericJWSHeader> configurer) {
        throw new IllegalStateException();
    }

    @Override
    public GenericJWSBuilder<A> payload(A payload) {
        throw new IllegalStateException();
    }

    @Override
    protected GenericJWSHeader buildJWSHeader() throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        this.checkHeader(this.jwsHeader);
        try {
            String encodedProtectedHeader = JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(this.mapper.writeValueAsBytes((Object)this.signatureProtectedJWSHeader));
            this.signatureProtectedJWSHeader.setEncoded(encodedProtectedHeader);
            this.jwsHeader.setEncoded(encodedProtectedHeader);
        }
        catch (JsonProcessingException e) {
            throw new JWSBuildException("Failed to encode JWS protected header", e);
        }
        return this.jwsHeader;
    }

    @Override
    protected Mono<GenericJWSPayload<A>> buildJWSPayload(Function<A, Mono<String>> overridingPayloadEncoder, String overridingContentType, GenericJWSHeader jwsHeader) throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        return this.jwsPayload;
    }
}

