/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jws;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.Init;
import io.inverno.mod.security.jose.internal.converter.GenericDataConversionService;
import io.inverno.mod.security.jose.internal.jws.GenericJWSBuilder;
import io.inverno.mod.security.jose.internal.jws.GenericJWSReader;
import io.inverno.mod.security.jose.internal.jws.GenericJsonJWSBuilder;
import io.inverno.mod.security.jose.internal.jws.GenericJsonJWSReader;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jws.JWSBuilder;
import io.inverno.mod.security.jose.jws.JWSReader;
import io.inverno.mod.security.jose.jws.JWSService;
import io.inverno.mod.security.jose.jws.JsonJWSBuilder;
import io.inverno.mod.security.jose.jws.JsonJWSReader;
import java.lang.reflect.Type;
import org.reactivestreams.Publisher;

@Bean(name="jwsService")
public class GenericJWSService
implements JWSService {
    private final ObjectMapper mapper;
    private final GenericDataConversionService dataConversionService;
    private final JWKService jwkService;

    public GenericJWSService(ObjectMapper mapper, GenericDataConversionService dataConversionService, JWKService jwkService) {
        this.mapper = mapper;
        this.dataConversionService = dataConversionService;
        this.jwkService = jwkService;
    }

    @Init
    public void init() {
        this.dataConversionService.injectJWSService(this);
    }

    @Override
    public <T> JWSBuilder<T, ?, ?> builder(Type type, Publisher<? extends JWK> keys) {
        return new GenericJWSBuilder(this.mapper, this.dataConversionService, this.jwkService, type, keys);
    }

    @Override
    public <T> JWSReader<T, ?> reader(Type type, Publisher<? extends JWK> keys) {
        return new GenericJWSReader(this.mapper, this.dataConversionService, this.jwkService, type, keys);
    }

    @Override
    public <T> JsonJWSBuilder<T, ?, ?> jsonBuilder(Type type) {
        return new GenericJsonJWSBuilder(this.mapper, this.dataConversionService, this.jwkService, type);
    }

    @Override
    public <T> JsonJWSReader<T, ?> jsonReader(Type type) {
        return new GenericJsonJWSReader(this.mapper, this.dataConversionService, this.jwkService, type);
    }
}

