/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jws;

import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.AbstractJOSEObject;
import io.inverno.mod.security.jose.internal.AbstractJOSEPayload;
import io.inverno.mod.security.jose.internal.jws.GenericJWSHeader;
import io.inverno.mod.security.jose.internal.jws.GenericJWSPayload;
import io.inverno.mod.security.jose.jws.JWS;
import io.inverno.mod.security.jose.jws.JWSHeader;
import java.util.Objects;

public class GenericJWS<A>
extends AbstractJOSEObject<A, JWSHeader, AbstractJOSEPayload<A>>
implements JWS<A> {
    private final String signature;
    private String compact;
    private String detachedCompact;

    public GenericJWS(GenericJWSHeader header, GenericJWSPayload<A> payload, String signature) {
        super(header, payload);
        this.signature = signature;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public String toCompact() throws JOSEProcessingException {
        if (this.compact == null) {
            StringBuilder compactBuilder = new StringBuilder();
            compactBuilder.append(((JWSHeader)this.header).getEncoded()).append(".");
            if (this.payload.getEncoded() != null) {
                compactBuilder.append(this.payload.getEncoded());
            } else if (this.payload.getRaw() != null) {
                if (this.payload.getRaw().contains(".")) {
                    throw new JOSEProcessingException("Unencoded payloads containing '.' characters must not be used with JWS compact representation");
                }
                compactBuilder.append(this.payload.getRaw());
            } else {
                compactBuilder.append("");
            }
            compactBuilder.append(".");
            if (this.signature != null) {
                compactBuilder.append(this.signature);
            }
            this.compact = compactBuilder.toString();
        }
        return this.compact;
    }

    @Override
    public String toDetachedCompact() throws JOSEProcessingException {
        if (this.detachedCompact == null) {
            this.detachedCompact = ((JWSHeader)this.header).getEncoded() + ".." + (this.signature != null ? this.signature : "");
        }
        return this.detachedCompact;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.signature);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericJWS other = (GenericJWS)obj;
        return Objects.equals(this.signature, other.signature);
    }
}

