/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.rsa;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.annotation.Bean;
import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.internal.jwk.AbstractX509JWKFactory;
import io.inverno.mod.security.jose.internal.jwk.SwitchableJWKURLResolver;
import io.inverno.mod.security.jose.internal.jwk.rsa.GenericRSAJWK;
import io.inverno.mod.security.jose.internal.jwk.rsa.GenericRSAJWKBuilder;
import io.inverno.mod.security.jose.internal.jwk.rsa.GenericRSAJWKGenerator;
import io.inverno.mod.security.jose.jwa.RSAAlgorithm;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKReadException;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.X509JWKCertPathValidator;
import io.inverno.mod.security.jose.jwk.rsa.RSAJWKFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class GenericRSAJWKFactory
extends AbstractX509JWKFactory<RSAPublicKey, RSAPrivateKey, GenericRSAJWK, GenericRSAJWKBuilder, GenericRSAJWKGenerator>
implements RSAJWKFactory<GenericRSAJWK, GenericRSAJWKBuilder, GenericRSAJWKGenerator> {
    private static final Set<String> SUPPORTED_ALGORITHMS = Arrays.stream(RSAAlgorithm.values()).map(RSAAlgorithm::getAlgorithm).collect(Collectors.toSet());

    public GenericRSAJWKFactory(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, ObjectMapper mapper, SwitchableJWKURLResolver urlResolver, X509JWKCertPathValidator certPathValidator) {
        super(configuration, jwkStore, keyResolver, mapper, urlResolver, certPathValidator);
    }

    @Override
    public boolean supports(String kty) {
        return "RSA".equals(kty);
    }

    @Override
    public boolean supportsAlgorithm(String alg) {
        return SUPPORTED_ALGORITHMS.contains(alg);
    }

    @Override
    public GenericRSAJWKBuilder builder() {
        return new GenericRSAJWKBuilder(this.configuration, this.jwkStore, this.keyResolver, this.urlResolver, this.certPathValidator);
    }

    @Override
    public GenericRSAJWKBuilder builder(Map<String, Object> parameters) throws JWKReadException {
        return new GenericRSAJWKBuilder(this.configuration, this.jwkStore, this.keyResolver, this.urlResolver, this.certPathValidator, parameters);
    }

    @Override
    public GenericRSAJWKGenerator generator() {
        return new GenericRSAJWKGenerator();
    }

    @Override
    public GenericRSAJWKGenerator generator(String alg, Map<String, Object> parameters) throws JWKGenerateException {
        return new GenericRSAJWKGenerator(parameters).algorithm(alg);
    }
}

