/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.pbes2;

import io.inverno.mod.security.jose.internal.jwk.AbstractJWKGenerator;
import io.inverno.mod.security.jose.internal.jwk.pbes2.GenericPBES2JWK;
import io.inverno.mod.security.jose.jwa.PBES2Algorithm;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.pbes2.PBES2JWKGenerator;
import java.util.Map;
import org.apache.commons.text.RandomStringGenerator;
import reactor.core.publisher.Mono;

public class GenericPBES2JWKGenerator
extends AbstractJWKGenerator<GenericPBES2JWK, GenericPBES2JWKGenerator>
implements PBES2JWKGenerator<GenericPBES2JWK, GenericPBES2JWKGenerator> {
    private static final RandomStringGenerator DEFAULT_RANDOM_STRING_GENERATOR = new RandomStringGenerator.Builder().build();
    private static final int MAXIMUM_LENGTH = 128;
    private static final int DEFAULT_LENGTH = PBES2Algorithm.PBES2_HS256_A128KW.getEncryptionKeyLength();
    private PBES2Algorithm pbes2Alg;
    private Integer length;
    private RandomStringGenerator randomStringGenerator;

    public GenericPBES2JWKGenerator() {
        this(null);
    }

    public GenericPBES2JWKGenerator(Map<String, Object> parameters) throws JWKGenerateException {
        super(parameters);
        if (this.length == null) {
            this.length = DEFAULT_LENGTH;
        }
        if (this.randomStringGenerator == null) {
            this.randomStringGenerator = DEFAULT_RANDOM_STRING_GENERATOR;
        }
    }

    @Override
    protected void set(String field, Object value) throws JWKGenerateException {
        switch (field) {
            case "length": {
                this.length((Integer)value);
                break;
            }
            case "randomStringGenerator": {
                this.randomStringGenerator((RandomStringGenerator)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    @Override
    public GenericPBES2JWKGenerator algorithm(String alg) {
        PBES2Algorithm pBES2Algorithm = this.pbes2Alg = alg != null ? PBES2Algorithm.fromAlgorithm(alg) : null;
        if (this.pbes2Alg != null) {
            this.length = this.pbes2Alg.getEncryptionKeyLength();
        }
        return (GenericPBES2JWKGenerator)super.algorithm(alg);
    }

    @Override
    public GenericPBES2JWKGenerator length(int length) {
        this.length = length;
        return this;
    }

    @Override
    public GenericPBES2JWKGenerator randomStringGenerator(RandomStringGenerator randomStringGenerator) {
        this.randomStringGenerator = randomStringGenerator != null ? randomStringGenerator : DEFAULT_RANDOM_STRING_GENERATOR;
        return this;
    }

    @Override
    protected Mono<Void> verify() throws JWKGenerateException, JWKProcessingException {
        return super.verify().then(Mono.fromRunnable(() -> {
            int minimumLength;
            int n = minimumLength = this.pbes2Alg != null ? this.pbes2Alg.getEncryptionKeyLength() : DEFAULT_LENGTH;
            if (this.length < minimumLength) {
                throw new JWKGenerateException("Password length must be at least " + minimumLength);
            }
            if (this.length > 128) {
                throw new JWKGenerateException("Password length must no longer than 128");
            }
        }));
    }

    @Override
    protected Mono<GenericPBES2JWK> doGenerate() throws JWKGenerateException, JWKProcessingException {
        return Mono.fromSupplier(() -> {
            String generatedPassword = this.randomStringGenerator.generate(this.length.intValue());
            GenericPBES2JWK jwk = new GenericPBES2JWK(generatedPassword);
            jwk.setAlgorithm(this.pbes2Alg);
            jwk.setKeyId(this.kid);
            jwk.setKeyOperations(this.key_ops);
            jwk.setPublicKeyUse(this.use);
            return jwk;
        });
    }
}

