/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.pbes2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.annotation.Bean;
import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.internal.jwk.AbstractJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.pbes2.GenericPBES2JWK;
import io.inverno.mod.security.jose.internal.jwk.pbes2.GenericPBES2JWKBuilder;
import io.inverno.mod.security.jose.internal.jwk.pbes2.GenericPBES2JWKGenerator;
import io.inverno.mod.security.jose.jwa.PBES2Algorithm;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKReadException;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.pbes2.PBES2JWKFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class GenericPBES2JWKFactory
extends AbstractJWKFactory<GenericPBES2JWK, GenericPBES2JWKBuilder, GenericPBES2JWKGenerator>
implements PBES2JWKFactory<GenericPBES2JWK, GenericPBES2JWKBuilder, GenericPBES2JWKGenerator> {
    private static final Set<String> SUPPORTED_ALGORITHMS = Arrays.stream(PBES2Algorithm.values()).map(PBES2Algorithm::getAlgorithm).collect(Collectors.toSet());

    public GenericPBES2JWKFactory(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, ObjectMapper mapper) {
        super(configuration, jwkStore, keyResolver, mapper);
    }

    @Override
    public boolean supports(String kty) {
        return "oct".equals(kty);
    }

    @Override
    public boolean supportsAlgorithm(String alg) {
        return SUPPORTED_ALGORITHMS.contains(alg);
    }

    @Override
    public GenericPBES2JWKBuilder builder() {
        return new GenericPBES2JWKBuilder(this.configuration, this.jwkStore, this.keyResolver);
    }

    @Override
    public GenericPBES2JWKBuilder builder(Map<String, Object> parameters) throws JWKReadException {
        return new GenericPBES2JWKBuilder(this.configuration, this.jwkStore, this.keyResolver, parameters);
    }

    @Override
    public GenericPBES2JWKGenerator generator() {
        return new GenericPBES2JWKGenerator();
    }

    @Override
    public GenericPBES2JWKGenerator generator(String alg, Map<String, Object> parameters) throws JWKGenerateException {
        return new GenericPBES2JWKGenerator(parameters);
    }
}

