/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.okp;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.annotation.Bean;
import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.internal.jwk.SwitchableJWKURLResolver;
import io.inverno.mod.security.jose.internal.jwk.okp.AbstractOKPJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericXECJWK;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericXECJWKBuilder;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericXECJWKGenerator;
import io.inverno.mod.security.jose.jwa.XECAlgorithm;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKReadException;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.X509JWKCertPathValidator;
import io.inverno.mod.security.jose.jwk.okp.XECJWKFactory;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class GenericXECJWKFactory
extends AbstractOKPJWKFactory<XECPublicKey, XECPrivateKey, GenericXECJWK, GenericXECJWKBuilder, GenericXECJWKGenerator>
implements XECJWKFactory<GenericXECJWK, GenericXECJWKBuilder, GenericXECJWKGenerator> {
    private static final Set<String> SUPPORTED_ALGORITHMS = Arrays.stream(XECAlgorithm.values()).map(XECAlgorithm::getAlgorithm).collect(Collectors.toSet());

    public GenericXECJWKFactory(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, ObjectMapper mapper, SwitchableJWKURLResolver urlResolver, X509JWKCertPathValidator certPathValidator) {
        super(configuration, jwkStore, keyResolver, mapper, urlResolver, certPathValidator);
    }

    @Override
    public boolean supportsAlgorithm(String alg) {
        return SUPPORTED_ALGORITHMS.contains(alg);
    }

    @Override
    public GenericXECJWKBuilder builder() {
        return new GenericXECJWKBuilder(this.configuration, this.jwkStore, this.keyResolver, this.urlResolver, this.certPathValidator);
    }

    @Override
    public GenericXECJWKBuilder builder(Map<String, Object> parameters) throws JWKReadException {
        return new GenericXECJWKBuilder(this.configuration, this.jwkStore, this.keyResolver, this.urlResolver, this.certPathValidator, parameters);
    }

    @Override
    public GenericXECJWKGenerator generator() {
        return new GenericXECJWKGenerator();
    }

    @Override
    public GenericXECJWKGenerator generator(String alg, Map<String, Object> parameters) throws JWKGenerateException {
        return new GenericXECJWKGenerator(parameters).algorithm(alg);
    }
}

