/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.okp;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.annotation.Bean;
import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.internal.jwk.SwitchableJWKURLResolver;
import io.inverno.mod.security.jose.internal.jwk.okp.AbstractOKPJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericEdECJWK;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericEdECJWKBuilder;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericEdECJWKGenerator;
import io.inverno.mod.security.jose.jwa.EdECAlgorithm;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKReadException;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.X509JWKCertPathValidator;
import io.inverno.mod.security.jose.jwk.okp.EdECJWKFactory;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.EdECPublicKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class GenericEdECJWKFactory
extends AbstractOKPJWKFactory<EdECPublicKey, EdECPrivateKey, GenericEdECJWK, GenericEdECJWKBuilder, GenericEdECJWKGenerator>
implements EdECJWKFactory<GenericEdECJWK, GenericEdECJWKBuilder, GenericEdECJWKGenerator> {
    private static final Set<String> SUPPORTED_ALGORITHMS = Arrays.stream(EdECAlgorithm.values()).map(EdECAlgorithm::getAlgorithm).collect(Collectors.toSet());

    public GenericEdECJWKFactory(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, ObjectMapper mapper, SwitchableJWKURLResolver urlResolver, X509JWKCertPathValidator certPathValidator) {
        super(configuration, jwkStore, keyResolver, mapper, urlResolver, certPathValidator);
    }

    @Override
    public boolean supportsAlgorithm(String alg) {
        return SUPPORTED_ALGORITHMS.contains(alg);
    }

    @Override
    public GenericEdECJWKBuilder builder() {
        return new GenericEdECJWKBuilder(this.configuration, this.jwkStore, this.keyResolver, this.urlResolver, this.certPathValidator);
    }

    @Override
    public GenericEdECJWKBuilder builder(Map<String, Object> parameters) throws JWKReadException {
        return new GenericEdECJWKBuilder(this.configuration, this.jwkStore, this.keyResolver, this.urlResolver, this.certPathValidator, parameters);
    }

    @Override
    public GenericEdECJWKGenerator generator() {
        return new GenericEdECJWKGenerator();
    }

    @Override
    public GenericEdECJWKGenerator generator(String alg, Map<String, Object> parameters) throws JWKGenerateException {
        return (GenericEdECJWKGenerator)new GenericEdECJWKGenerator(parameters).algorithm(alg);
    }
}

