/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.okp;

import io.inverno.mod.security.jose.internal.jwk.okp.AbstractOKPJWK;
import io.inverno.mod.security.jose.jwa.EdECAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwa.OKPCurve;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.okp.EdECJWK;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.EdECPublicKey;
import java.security.spec.EdECPoint;
import java.security.spec.EdECPrivateKeySpec;
import java.security.spec.EdECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.NamedParameterSpec;
import java.util.Base64;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class GenericEdECJWK
extends AbstractOKPJWK<EdECPublicKey, EdECPrivateKey>
implements EdECJWK {
    public static final Set<OKPCurve> SUPPORTED_CURVES = Set.of(OKPCurve.ED25519, OKPCurve.ED448);
    private EdECAlgorithm edecAlg;
    private JWASigner signer;

    public GenericEdECJWK(OKPCurve curve, String x) {
        super(curve, x);
    }

    public GenericEdECJWK(OKPCurve curve, String x, X509Certificate certificate) {
        super(curve, x, certificate);
    }

    public GenericEdECJWK(OKPCurve curve, String x, String d) {
        super(curve, x, d);
    }

    public GenericEdECJWK(OKPCurve curve, String x, String d, EdECPrivateKey key, boolean trusted) {
        super(curve, x, d, key, trusted);
    }

    public GenericEdECJWK(OKPCurve curve, String x, String d, X509Certificate certificate) {
        super(curve, x, d, certificate);
    }

    public GenericEdECJWK(OKPCurve curve, String x, String d, EdECPrivateKey key, X509Certificate certificate, boolean trusted) {
        super(curve, x, d, key, certificate, trusted);
    }

    public void setAlgorithm(EdECAlgorithm edecAlg) {
        super.setAlgorithm(edecAlg != null ? edecAlg.getAlgorithm() : null);
        this.edecAlg = edecAlg;
    }

    @Override
    public void setAlgorithm(String alg) {
        this.edecAlg = alg != null ? EdECAlgorithm.fromAlgorithm(alg, this.curve) : null;
        super.setAlgorithm(alg);
    }

    @Override
    public EdECJWK trust() {
        this.trusted = true;
        return this;
    }

    @Override
    public EdECPublicKey toPublicKey() throws JWKProcessingException {
        if (this.publicKey == null) {
            this.publicKey = this.certificate.map(cert -> (EdECPublicKey)cert.getPublicKey()).orElseGet(() -> {
                try {
                    byte[] encodedPoint = Base64.getUrlDecoder().decode(this.x);
                    byte msb = encodedPoint[encodedPoint.length - 1];
                    int n = encodedPoint.length - 1;
                    encodedPoint[n] = (byte)(encodedPoint[n] & 0x7F);
                    boolean xOdd = (msb & 0x80) != 0;
                    GenericEdECJWK.reverse(encodedPoint);
                    BigInteger y = new BigInteger(1, encodedPoint);
                    EdECPublicKeySpec edEcPublicKeySpec = new EdECPublicKeySpec(new NamedParameterSpec(this.curve.getJCAName()), new EdECPoint(xOdd, y));
                    return (EdECPublicKey)KeyFactory.getInstance(this.curve.getJCAName()).generatePublic(edEcPublicKeySpec);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new JWKProcessingException("Error converting JWK to public key", e);
                }
            });
        }
        return (EdECPublicKey)this.publicKey;
    }

    @Override
    public Optional<EdECPrivateKey> toPrivateKey() throws JWKProcessingException {
        if (this.privateKey == null) {
            this.privateKey = Optional.ofNullable(this.d).map(pk -> {
                try {
                    EdECPrivateKeySpec edEcPrivateKeySpec = new EdECPrivateKeySpec(new NamedParameterSpec(this.curve.getJCAName()), Base64.getUrlDecoder().decode((String)pk));
                    return (EdECPrivateKey)KeyFactory.getInstance(this.curve.getJCAName()).generatePrivate(edEcPrivateKeySpec);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new JWKProcessingException("Error converting JWK to private key", e);
                }
            });
        }
        return this.privateKey;
    }

    @Override
    public EdECJWK toPublicJWK() {
        GenericEdECJWK jwk = new GenericEdECJWK(this.curve, this.x, this.certificate.orElse(null));
        jwk.publicKey = this.publicKey;
        jwk.setPublicKeyUse(this.use);
        jwk.setKeyOperations(this.key_ops);
        jwk.setAlgorithm(this.edecAlg);
        jwk.setKeyId(this.kid);
        jwk.setX509CertificateURL(this.x5u);
        jwk.setX509CertificateChain(this.x5c);
        jwk.setX509CertificateSHA1Thumbprint(this.x5t);
        jwk.setX509CertificateSHA256Thumbprint(this.x5t_S256);
        return jwk;
    }

    @Override
    public EdECJWK minify() {
        GenericEdECJWK jwk = new GenericEdECJWK(this.curve, this.x, this.d, (EdECPrivateKey)this.key, (X509Certificate)this.certificate.orElse(null), this.trusted);
        jwk.publicKey = this.publicKey;
        return jwk;
    }

    @Override
    public boolean supportsAlgorithm(String alg) {
        try {
            EdECAlgorithm.fromAlgorithm(alg, this.curve);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public JWASigner signer() throws JWKProcessingException {
        this.checkSignature(this.edecAlg);
        if (this.signer == null) {
            this.signer = this.edecAlg.createSigner(this);
        }
        return this.signer;
    }

    @Override
    public JWASigner signer(String alg) throws JWKProcessingException {
        if (StringUtils.isBlank((CharSequence)alg)) {
            return this.signer();
        }
        EdECAlgorithm algorithm = EdECAlgorithm.fromAlgorithm(alg, this.curve);
        this.checkSignature(algorithm);
        if (this.signer == null) {
            this.signer = algorithm.createSigner(this);
        }
        return this.signer;
    }

    @Override
    protected void checkSignature(JWAAlgorithm<?> algorithm) throws JWKProcessingException {
        super.checkSignature(algorithm);
        if (!this.curve.equals((Object)((EdECAlgorithm)algorithm).getCurve())) {
            throw new JWKProcessingException("JWK with curve " + this.curve + " doesn't support algorithm " + algorithm);
        }
    }
}

