/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.okp;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwk.AbstractX509JWK;
import io.inverno.mod.security.jose.jwa.OKPCurve;
import io.inverno.mod.security.jose.jwk.okp.OKPJWK;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractOKPJWK<A extends PublicKey, B extends PrivateKey>
extends AbstractX509JWK<A, B>
implements OKPJWK<A, B> {
    protected final OKPCurve curve;
    protected final String x;
    protected final String d;
    protected A publicKey;
    protected Optional<B> privateKey;

    public AbstractOKPJWK(OKPCurve curve, String x) {
        this(curve, x, null, null, null, false);
    }

    public AbstractOKPJWK(OKPCurve curve, String x, X509Certificate certificate) {
        this(curve, x, null, null, certificate, certificate != null);
    }

    public AbstractOKPJWK(OKPCurve curve, String x, String d) {
        this(curve, x, d, null, null, false);
    }

    public AbstractOKPJWK(OKPCurve curve, String x, String d, B key, boolean trusted) {
        this(curve, x, d, key, null, trusted);
    }

    public AbstractOKPJWK(OKPCurve curve, String x, String d, X509Certificate certificate) {
        this(curve, x, null, null, certificate, certificate != null);
    }

    public AbstractOKPJWK(OKPCurve curve, String x, String d, B key, X509Certificate certificate, boolean trusted) {
        super("OKP", (PrivateKey)key, certificate, trusted);
        this.curve = curve;
        this.x = x;
        this.d = d;
        this.privateKey = key != null ? Optional.of(key) : null;
    }

    @Override
    public String getCurve() {
        return this.curve.getCurve();
    }

    @Override
    public String getPublicKey() {
        return this.x;
    }

    @Override
    public String getPrivateKey() {
        return this.d;
    }

    @Override
    public String toJWKThumbprint(MessageDigest digest) {
        return AbstractOKPJWK.toJWKThumbprint(digest, this.curve.getCurve(), this.kty, this.x);
    }

    static String toJWKThumbprint(MessageDigest digest, String crv, String kty, String x) {
        if (crv == null || kty == null || x == null) {
            return null;
        }
        StringBuilder input = new StringBuilder();
        input.append('{');
        input.append("\"crv\":\"").append(crv).append("\",");
        input.append("\"kty\":\"").append(kty).append("\",");
        input.append("\"x\":\"").append(x).append("\"");
        input.append('}');
        return JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(digest.digest(input.toString().getBytes()));
    }

    protected static void reverse(byte[] arr) {
        int i = 0;
        for (int j = arr.length - 1; i < j; ++i, --j) {
            AbstractOKPJWK.swap(arr, i, j);
        }
    }

    protected static void swap(byte[] arr, int i, int j) {
        byte tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.curve, this.d, this.x});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractOKPJWK other = (AbstractOKPJWK)obj;
        return this.curve == other.curve && Objects.equals(this.d, other.d) && Objects.equals(this.x, other.x);
    }
}

