/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.oct;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwk.AbstractJWKGenerator;
import io.inverno.mod.security.jose.internal.jwk.oct.GenericOCTJWK;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.oct.OCTJWKGenerator;
import java.security.SecureRandom;
import java.util.Map;
import reactor.core.publisher.Mono;

public class GenericOCTJWKGenerator
extends AbstractJWKGenerator<GenericOCTJWK, GenericOCTJWKGenerator>
implements OCTJWKGenerator<GenericOCTJWK, GenericOCTJWKGenerator> {
    public static final int MINIMUM_KEY_SIZE = 16;
    public static final int DEFAULT_KEY_SIZE = 32;
    private OCTAlgorithm octAlg;
    private Integer keySize;
    private SecureRandom secureRandom;

    public GenericOCTJWKGenerator() {
        this(null);
    }

    public GenericOCTJWKGenerator(Map<String, Object> parameters) throws JWKGenerateException {
        super(parameters);
        if (this.secureRandom == null) {
            this.secureRandom = JOSEUtils.DEFAULT_SECURE_RANDOM;
        }
    }

    @Override
    protected void set(String field, Object value) throws JWKGenerateException {
        switch (field) {
            case "keySize": {
                this.keySize((Integer)value);
                break;
            }
            case "secureRandom": {
                this.secureRandom((SecureRandom)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    @Override
    public GenericOCTJWKGenerator algorithm(String alg) {
        OCTAlgorithm oCTAlgorithm = this.octAlg = alg != null ? OCTAlgorithm.fromAlgorithm(alg) : null;
        if (this.octAlg != null) {
            this.keySize = this.octAlg.getEncryptionKeyLength() + (this.octAlg.getMacKeyLength() != null ? this.octAlg.getMacKeyLength() : 0);
        }
        return (GenericOCTJWKGenerator)super.algorithm(alg);
    }

    @Override
    public GenericOCTJWKGenerator keySize(int keySize) {
        this.keySize = keySize;
        return this;
    }

    @Override
    public GenericOCTJWKGenerator secureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom != null ? secureRandom : JOSEUtils.DEFAULT_SECURE_RANDOM;
        return this;
    }

    @Override
    protected Mono<Void> verify() throws JWKGenerateException, JWKProcessingException {
        return super.verify().then(Mono.fromRunnable(() -> {
            if (this.keySize != null) {
                int macKeyLength;
                if (this.keySize < 16) {
                    throw new JWKGenerateException("Key size must be at least 16");
                }
                int n = macKeyLength = this.octAlg.getMacKeyLength() != null ? this.octAlg.getMacKeyLength() : 0;
                if (this.octAlg != null && this.keySize != this.octAlg.getEncryptionKeyLength() + macKeyLength) {
                    throw new JWKGenerateException("Key size " + this.keySize + " is inconsistent with algorithm " + this.octAlg.getAlgorithm() + " which requires " + (this.octAlg.getEncryptionKeyLength() + macKeyLength));
                }
            }
        }));
    }

    @Override
    public Mono<GenericOCTJWK> doGenerate() throws JWKGenerateException, JWKProcessingException {
        return Mono.fromSupplier(() -> {
            byte[] keyBytes = new byte[this.keySize != null ? this.keySize : 32];
            this.secureRandom.nextBytes(keyBytes);
            GenericOCTJWK jwk = new GenericOCTJWK(JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(keyBytes));
            jwk.setPublicKeyUse(this.use);
            jwk.setKeyOperations(this.key_ops);
            jwk.setKeyId(this.kid);
            jwk.setAlgorithm(this.octAlg);
            return jwk;
        });
    }
}

