/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.Overridable;
import io.inverno.mod.security.jose.jwk.JWKResolveException;
import io.inverno.mod.security.jose.jwk.X509JWKCertPathValidator;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Overridable
@Bean(name="jwkX509CertPathValidator", visibility=Bean.Visibility.PRIVATE)
public class GenericX509JWKCertPathValidator
implements X509JWKCertPathValidator {
    private final PKIXParameters pkixParameters;
    private final Scheduler scheduler;

    public GenericX509JWKCertPathValidator(PKIXParameters pkixParameters, ExecutorService executor) {
        this.pkixParameters = pkixParameters;
        this.scheduler = Schedulers.fromExecutor((Executor)executor);
    }

    @Override
    public Mono<X509Certificate> validate(List<X509Certificate> certificates) throws JWKResolveException {
        return Mono.fromSupplier(() -> {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                CertPath certChain = cf.generateCertPath(certificates);
                CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
                cpv.validate(certChain, this.pkixParameters);
                return (X509Certificate)certificates.get(0);
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | CertPathValidatorException | CertificateException e) {
                throw new JWKResolveException("Error validating X.509 certificate: ", e);
            }
        }).subscribeOn(this.scheduler);
    }
}

