/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.Overridable;
import io.inverno.mod.base.resource.ResourceService;
import io.inverno.mod.security.jose.jwk.JWKResolveException;
import io.inverno.mod.security.jose.jwk.JWKURLResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.Pipe;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Overridable
@Bean(name="jwkURLResolver", visibility=Bean.Visibility.PRIVATE)
public class GenericJWKURLResolver
implements JWKURLResolver {
    private static final Logger LOGGER = LogManager.getLogger(GenericJWKURLResolver.class);
    private final ObjectMapper mapper;
    private ResourceService resourceService;

    public GenericJWKURLResolver(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    @Override
    public Publisher<Map<String, Object>> resolveJWKSetURL(URI jku) throws JWKResolveException {
        return Mono.justOrEmpty((Object)jku).filter(ign -> {
            if (this.resourceService == null) {
                LOGGER.warn("JWK set URL resolver is disabled: missing resource service");
                return false;
            }
            return true;
        }).flatMapMany(uri -> Flux.from((Publisher)((Publisher)this.resourceService.getResource(uri).read().orElseThrow(() -> new JWKResolveException("Unable to retrieve JWK set from URL, resource is not readable: " + uri)))).reduceWith(() -> {
            try {
                return Pipe.open();
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't open pipe", e);
            }
        }, (pipe, chunk) -> {
            try {
                chunk.getBytes(0, (GatheringByteChannel)pipe.sink(), chunk.readableBytes());
            }
            catch (IOException e) {
                throw new JWKResolveException("Error resolving JWK Set from URL: " + uri, e);
            }
            finally {
                chunk.release();
            }
            return pipe;
        }).flatMapMany(pipe -> {
            try {
                pipe.sink().close();
                try (InputStream jkuStream = Channels.newInputStream(pipe.source());){
                    Map parsedJku;
                    try {
                        parsedJku = (Map)this.mapper.readerForMapOf(Object.class).readValue(jkuStream);
                    }
                    catch (JsonProcessingException e) {
                        throw new JWKResolveException("Error reading JWK", e);
                    }
                    if (parsedJku.containsKey("keys")) {
                        Flux flux2 = Flux.fromIterable((Iterable)((List)parsedJku.get("keys")));
                        return flux2;
                    }
                    Flux flux = Flux.just((Object)parsedJku);
                    return flux;
                }
            }
            catch (IOException e) {
                throw new JWKResolveException("Error resolving JWK Set from URL: " + uri, e);
            }
        }).onErrorStop());
    }

    @Override
    public Mono<List<X509Certificate>> resolveX509CertificateURL(URI x5u) throws JWKResolveException {
        return Mono.justOrEmpty((Object)x5u).filter(ign -> {
            if (this.resourceService == null) {
                LOGGER.warn("X509 certificate URL resolver is disabled: missing resource service");
                return false;
            }
            return true;
        }).flatMap(uri -> Flux.from((Publisher)((Publisher)this.resourceService.getResource(uri).read().orElseThrow(() -> new JWKResolveException("Unable to retrieve X.509 certificate chain from URL, resource is not readable: " + uri)))).reduceWith(() -> {
            try {
                return Pipe.open();
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't open pipe", e);
            }
        }, (pipe, chunk) -> {
            try {
                chunk.getBytes(0, (GatheringByteChannel)pipe.sink(), chunk.readableBytes());
            }
            catch (IOException e) {
                throw new JWKResolveException("Error resolving X.509 certificate chain from URL: " + uri, e);
            }
            finally {
                chunk.release();
            }
            return pipe;
        }).map(pipe -> {
            List list;
            block8: {
                pipe.sink().close();
                InputStream x5uStream = Channels.newInputStream(pipe.source());
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    list = cf.generateCertificates(x5uStream).stream().map(c -> (X509Certificate)c).collect(Collectors.toList());
                    if (x5uStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (x5uStream != null) {
                            try {
                                x5uStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | CertificateException e) {
                        throw new JWKResolveException("Error resolving X.509 certificate chain from URL: " + uri, e);
                    }
                }
                x5uStream.close();
            }
            return list;
        }).onErrorStop());
    }
}

