/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.annotation.Bean;
import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.JOSEHeader;
import io.inverno.mod.security.jose.internal.jwk.SwitchableJWKURLResolver;
import io.inverno.mod.security.jose.internal.jwk.ec.GenericECJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.oct.GenericOCTJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericEdECJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericXECJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.pbes2.GenericPBES2JWKFactory;
import io.inverno.mod.security.jose.internal.jwk.rsa.GenericRSAJWKFactory;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKBuildException;
import io.inverno.mod.security.jose.jwk.JWKFactory;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.JWKReadException;
import io.inverno.mod.security.jose.jwk.JWKResolveException;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.JWKURLResolver;
import io.inverno.mod.security.jose.jwk.ec.ECJWK;
import io.inverno.mod.security.jose.jwk.ec.ECJWKFactory;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import io.inverno.mod.security.jose.jwk.oct.OCTJWKFactory;
import io.inverno.mod.security.jose.jwk.okp.EdECJWK;
import io.inverno.mod.security.jose.jwk.okp.EdECJWKFactory;
import io.inverno.mod.security.jose.jwk.okp.XECJWK;
import io.inverno.mod.security.jose.jwk.okp.XECJWKFactory;
import io.inverno.mod.security.jose.jwk.pbes2.PBES2JWK;
import io.inverno.mod.security.jose.jwk.pbes2.PBES2JWKFactory;
import io.inverno.mod.security.jose.jwk.rsa.RSAJWK;
import io.inverno.mod.security.jose.jwk.rsa.RSAJWKFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Bean(name="jwkService")
public final class GenericJWKService
implements JWKService {
    private static final Logger LOGGER = LogManager.getLogger(GenericJWKService.class);
    private final JOSEConfiguration configuration;
    private final GenericECJWKFactory ecJWKFactory;
    private final GenericRSAJWKFactory rsaJWKFactory;
    private final GenericOCTJWKFactory octJWKFactory;
    private final GenericEdECJWKFactory edecJWKFactory;
    private final GenericXECJWKFactory xecJWKFactory;
    private final GenericPBES2JWKFactory pbes2JWKFactory;
    private final JWKStore jwkStore;
    private final JWKURLResolver urlResolver;
    private final SwitchableJWKURLResolver switchableUrlResolver;
    private final ObjectMapper mapper;
    private final List<JWKFactory<?, ?, ?>> jwkFactories;

    public GenericJWKService(JOSEConfiguration configuration, GenericECJWKFactory ecJWKFactory, GenericRSAJWKFactory rsaJWKFactory, GenericOCTJWKFactory octJWKFactory, GenericEdECJWKFactory edecJWKFactory, GenericXECJWKFactory xecJWKFactory, GenericPBES2JWKFactory pbes2JWKFactory, JWKStore jwkStore, JWKURLResolver urlResolver, SwitchableJWKURLResolver switchableUrlResolver, ObjectMapper mapper) {
        this.configuration = configuration;
        this.ecJWKFactory = ecJWKFactory;
        this.rsaJWKFactory = rsaJWKFactory;
        this.octJWKFactory = octJWKFactory;
        this.edecJWKFactory = edecJWKFactory;
        this.xecJWKFactory = xecJWKFactory;
        this.pbes2JWKFactory = pbes2JWKFactory;
        this.jwkStore = jwkStore;
        this.urlResolver = urlResolver;
        this.switchableUrlResolver = switchableUrlResolver;
        this.mapper = mapper;
        this.jwkFactories = new LinkedList();
        this.setJWKFactories(null);
    }

    public void setJWKFactories(List<JWKFactory<?, ?, ?>> jwkFactories) {
        this.jwkFactories.clear();
        this.jwkFactories.add(this.ecJWKFactory);
        this.jwkFactories.add(this.rsaJWKFactory);
        this.jwkFactories.add(this.octJWKFactory);
        this.jwkFactories.add(this.edecJWKFactory);
        this.jwkFactories.add(this.xecJWKFactory);
        this.jwkFactories.add(this.pbes2JWKFactory);
        if (jwkFactories != null && !jwkFactories.isEmpty()) {
            jwkFactories.stream().filter(factory -> factory != null && factory != this.ecJWKFactory && factory != this.rsaJWKFactory && factory != this.octJWKFactory && factory != this.edecJWKFactory && factory != this.xecJWKFactory && factory != this.pbes2JWKFactory).forEach(this.jwkFactories::add);
        }
    }

    @Override
    public ECJWKFactory<? extends ECJWK, ?, ?> ec() {
        return this.ecJWKFactory;
    }

    @Override
    public RSAJWKFactory<? extends RSAJWK, ?, ?> rsa() {
        return this.rsaJWKFactory;
    }

    @Override
    public OCTJWKFactory<? extends OCTJWK, ?, ?> oct() {
        return this.octJWKFactory;
    }

    @Override
    public EdECJWKFactory<? extends EdECJWK, ?, ?> edec() {
        return this.edecJWKFactory;
    }

    @Override
    public XECJWKFactory<? extends XECJWK, ?, ?> xec() {
        return this.xecJWKFactory;
    }

    @Override
    public PBES2JWKFactory<? extends PBES2JWK, ?, ?> pbes2() {
        return this.pbes2JWKFactory;
    }

    @Override
    public Publisher<? extends JWK> read(String jwk) throws JWKReadException, JWKBuildException, JWKProcessingException {
        Map parsedJWK;
        try {
            parsedJWK = (Map)this.mapper.readerForMapOf(Object.class).readValue(jwk);
        }
        catch (JsonProcessingException e) {
            throw new JWKReadException("Error reading JWK", e);
        }
        if (parsedJWK.containsKey("keys")) {
            List keysValue;
            try {
                keysValue = (List)parsedJWK.get("keys");
            }
            catch (ClassCastException e) {
                throw new JWKReadException("Invalid JWK set", e);
            }
            return Flux.fromIterable((Iterable)keysValue).flatMap(keyElementValue -> {
                Map keyElement;
                try {
                    keyElement = (Map)keyElementValue;
                }
                catch (ClassCastException e) {
                    throw new JWKReadException("Invalid JWK set", e);
                }
                return this.read(keyElement, true);
            });
        }
        return this.read(parsedJWK, true);
    }

    @Override
    public Publisher<? extends JWK> read(Map<String, Object> jwk) throws JWKReadException, JWKBuildException, JWKProcessingException {
        return this.read(jwk, true);
    }

    @Override
    public Publisher<? extends JWK> read(URI uri) throws JWKReadException, JWKResolveException, JWKBuildException, JWKProcessingException {
        if (uri == null) {
            return Mono.empty();
        }
        Flux keys = Flux.from(this.urlResolver.resolveJWKSetURL(uri)).flatMap(jwk -> this.read((Map<String, Object>)jwk, true));
        if (this.configuration.trusted_jku().contains(uri)) {
            return keys.doOnNext(JWK::trust);
        }
        return keys;
    }

    @Override
    public Publisher<? extends JWK> read(JOSEHeader header) throws JWKReadException, JWKResolveException, JWKBuildException, JWKProcessingException {
        Map<String, Object> jwk = header.getJWK();
        if (jwk != null && !jwk.isEmpty()) {
            return this.read(this.mergeWithHeader(header.getJWK(), header), false);
        }
        return Flux.concat((Publisher[])new Publisher[]{this.resolveJku(header), Flux.defer(() -> Flux.from(this.read(this.mergeWithHeader(Map.of(), header), false)).onErrorResume(e -> Mono.empty()))});
    }

    @Override
    public Publisher<? extends JWK> generate(String alg, Map<String, Object> parameters) throws JWKGenerateException, JWKProcessingException {
        if (StringUtils.isBlank((CharSequence)alg)) {
            throw new JWKGenerateException("Algorithm is blank");
        }
        return Flux.defer(() -> {
            JWKGenerateException error = new JWKGenerateException("Failed to generate JWK");
            return Flux.fromIterable(this.jwkFactories).filter(factory -> factory.supportsAlgorithm(alg)).switchIfEmpty((Publisher)Mono.error(() -> new JWKReadException("No JWK factory found supporting algorithm " + alg))).concatMap(factory -> factory.generate(alg, parameters).doOnError(e -> {
                error.addSuppressed((Throwable)e);
                LOGGER.debug("Error generating JWK with factory: " + factory, e);
            }).onErrorResume(e -> Mono.empty())).switchIfEmpty((Publisher)Mono.error((Throwable)error));
        });
    }

    @Override
    public JWKStore store() {
        return this.jwkStore;
    }

    private Publisher<? extends JWK> read(Map<String, Object> jwk, boolean requiresKeyType) throws JWKReadException, JWKBuildException, JWKProcessingException {
        if (requiresKeyType && StringUtils.isBlank((CharSequence)((String)jwk.get("kty")))) {
            throw new JWKReadException("Key type is blank");
        }
        try {
            String kty = (String)jwk.get("kty");
            String alg = (String)jwk.get("alg");
            return Flux.defer(() -> {
                JWKReadException error = new JWKReadException("Failed to resolve JWK");
                return Flux.fromIterable(this.jwkFactories).filter(factory -> kty == null || factory.supports(kty)).filter(factory -> alg == null || factory.supportsAlgorithm(alg)).switchIfEmpty((Publisher)Mono.error(() -> new JWKReadException("No JWK factory found supporting key type " + kty + " and algorithm " + alg))).concatMap(factory -> factory.read(jwk).doOnError(e -> {
                    error.addSuppressed((Throwable)e);
                    LOGGER.debug("Error resolving JWK with factory: " + factory, e);
                }).onErrorResume(e -> Mono.empty())).switchIfEmpty((Publisher)Mono.error((Throwable)error));
            });
        }
        catch (ClassCastException e) {
            throw new JWKReadException("Invalid JWK string", e);
        }
    }

    private Map<String, Object> mergeWithHeader(Map<String, Object> jwk, JOSEHeader header) throws JWKReadException {
        HashMap<String, Object> mergedJWK = new HashMap<String, Object>(jwk);
        String alg = header.getAlgorithm();
        mergedJWK.compute("alg", (k, v) -> {
            if (v == null) {
                return alg;
            }
            if (!v.equals(alg)) {
                throw new JWKReadException("Inconsistent JWK: algorithm does not match JOSE header");
            }
            return v;
        });
        String kid = header.getKeyId();
        mergedJWK.compute("kid", (k, v) -> {
            if (v == null) {
                return kid;
            }
            if (!StringUtils.isBlank((CharSequence)kid) && !v.equals(kid)) {
                throw new JWKReadException("Inconsistent JWK: key id does not match JOSE header");
            }
            return v;
        });
        URI x5u = header.getX509CertificateURL();
        mergedJWK.compute("x5u", (k, v) -> {
            if (v == null) {
                return x5u;
            }
            if (x5u != null) {
                if (v instanceof URL) {
                    try {
                        v = ((URL)v).toURI().normalize();
                    }
                    catch (URISyntaxException e) {
                        throw new JWKReadException("Invalid x5u which must be a valid URI", e);
                    }
                } else if (v instanceof CharSequence) {
                    v = URI.create(v.toString()).normalize();
                } else if (!(v instanceof URI)) {
                    throw new JWKReadException(v.getClass() + " cannot be converted to URI");
                }
                if (!v.equals(x5u.normalize())) {
                    throw new JWKReadException("Inconsistent JWK: X.509 URL doesn't match JOSE header");
                }
            }
            return v;
        });
        String[] x5c = header.getX509CertificateChain();
        mergedJWK.compute("x5c", (k, v) -> {
            if (v == null) {
                return x5c;
            }
            if (x5c != null) {
                if (v instanceof Collection) {
                    v = ((Collection)v).toArray(String[]::new);
                } else if (!(v instanceof String[])) {
                    throw new JWKReadException("x5c can't be converted to String[]: " + v.getClass());
                }
                if (Arrays.compare((Comparable[])x5c, (Comparable[])((String[])v)) != 0) {
                    throw new JWKReadException("Inconsistent JWK: X.509 chain does not match JOSE header");
                }
            }
            return v;
        });
        String x5t = header.getX509CertificateSHA1Thumbprint();
        mergedJWK.compute("x5t", (k, v) -> {
            if (v == null) {
                return x5t;
            }
            if (!StringUtils.isBlank((CharSequence)x5t) && !v.equals(x5t)) {
                throw new JWKReadException("Inconsistent JWK: X.509 thumbprint does not match JOSE header");
            }
            return v;
        });
        String x5t_S256 = header.getX509CertificateSHA256Thumbprint();
        mergedJWK.compute("x5t#S256", (k, v) -> {
            if (v == null) {
                return x5t_S256;
            }
            if (!StringUtils.isBlank((CharSequence)x5t_S256) && !v.equals(x5t_S256)) {
                throw new JWKReadException("Inconsistent JWK: X.509 SHA-256 thumbprint does not match JOSE header");
            }
            return v;
        });
        return mergedJWK;
    }

    private Flux<? extends JWK> resolveJku(JOSEHeader header) throws JWKReadException, JWKResolveException, JWKBuildException, JWKProcessingException {
        URI jku = header.getJWKSetURL();
        if (jku == null) {
            return Flux.empty();
        }
        Flux keys = Flux.from(this.switchableUrlResolver.resolveJWKSetURL(jku)).mapNotNull(jwk -> {
            try {
                return this.mergeWithHeader((Map<String, Object>)jwk, header);
            }
            catch (Exception e) {
                LOGGER.debug(() -> {
                    try {
                        return "Key is inconsistent with JOSE header: " + this.mapper.writeValueAsString(jwk);
                    }
                    catch (JsonProcessingException jpe) {
                        throw new UncheckedIOException((IOException)((Object)jpe));
                    }
                }, (Throwable)e);
                return null;
            }
        }).flatMap(jwk -> Flux.from(this.read((Map<String, Object>)jwk, true)).onErrorResume(e -> Mono.empty()));
        if (this.configuration.trusted_jku().contains(jku)) {
            return keys.doOnNext(JWK::trust);
        }
        return keys;
    }

    @Bean(name="jwkFactories")
    public static interface JWKFactoriesSocket
    extends Supplier<List<JWKFactory<?, ?, ?>>> {
    }
}

