/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.Init;
import io.inverno.core.annotation.Overridable;
import io.inverno.mod.base.resource.Resource;
import io.inverno.mod.base.resource.ResourceService;
import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.JWKResolveException;
import java.io.IOException;
import java.nio.channels.Channels;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import reactor.core.publisher.Mono;

@Overridable
@Bean(name="jwkKeyResolver", visibility=Bean.Visibility.PRIVATE)
public class GenericJWKKeyResolver
implements JWKKeyResolver {
    private final JOSEConfiguration configuration;
    private ResourceService resourceService;
    private KeyStore keyStore;
    private char[] password;

    public GenericJWKKeyResolver(JOSEConfiguration configuration) {
        this.configuration = configuration;
    }

    @Init
    public void init() throws JWKProcessingException {
        if (this.keyStore == null && this.configuration.key_store() != null && this.resourceService != null) {
            try (Resource keystoreResource = this.resourceService.getResource(this.configuration.key_store());){
                this.password = this.configuration.key_store_password() != null ? this.configuration.key_store_password().toCharArray() : new char[]{};
                this.keyStore = keystoreResource.openReadableByteChannel().map(channel -> {
                    try {
                        KeyStore ks = KeyStore.getInstance(this.configuration.key_store_type());
                        ks.load(Channels.newInputStream(channel), this.password);
                        return ks;
                    }
                    catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                        throw new JWKProcessingException("Error loading JWK keystore", e);
                    }
                }).orElseThrow(() -> {
                    throw new JWKProcessingException("Error loading JWK keystore, resource does not exist or is not readable: " + this.configuration.key_store());
                });
            }
        }
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setKeyStore(KeyStore keyStore, char[] password) {
        this.keyStore = keyStore;
        this.password = password;
    }

    @Override
    public Mono<? extends Key> resolveKeyFromX509CertificateSHA1Thumbprint(String x5t) throws JWKResolveException {
        return this.resolveKeyFromKeyId(x5t);
    }

    @Override
    public Mono<? extends Key> resolveKeyFromX509CertificateSHA256Thumbprint(String x5t_S256) throws JWKResolveException {
        return this.resolveKeyFromKeyId(x5t_S256);
    }

    @Override
    public Mono<? extends Key> resolveKeyFromKeyId(String kid) throws JWKResolveException {
        return Mono.justOrEmpty((Object)kid).filter(ign -> this.keyStore != null).mapNotNull(alias -> {
            try {
                return this.keyStore.getKey((String)alias, this.password);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new JWKResolveException("Error accessing keystore", e);
            }
        });
    }

    @Override
    public Mono<X509Certificate> resolveCertificateFromX509CertificateSHA1Thumbprint(String x5t) throws JWKResolveException {
        return this.resolveCertificateFromKeyId(x5t);
    }

    @Override
    public Mono<X509Certificate> resolveCertificateFromX509CertificateSHA256Thumbprint(String x5t_S256) throws JWKResolveException {
        return this.resolveCertificateFromKeyId(x5t_S256);
    }

    @Override
    public Mono<X509Certificate> resolveCertificateFromKeyId(String kid) throws JWKResolveException {
        return Mono.justOrEmpty((Object)kid).filter(ign -> this.keyStore != null).mapNotNull(alias -> {
            try {
                Certificate tmpCert = this.keyStore.getCertificate((String)alias);
                if (tmpCert != null && !(tmpCert instanceof X509Certificate)) {
                    throw new JWKResolveException("Certificate is not a X.509 certificate");
                }
                return (X509Certificate)tmpCert;
            }
            catch (KeyStoreException e) {
                throw new JWKResolveException("Error accessing keystore", e);
            }
        });
    }
}

