/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk;

import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.internal.jwk.AbstractJWKBuilder;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKBuildException;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.JWKReadException;
import io.inverno.mod.security.jose.jwk.JWKResolveException;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.JWKURLResolver;
import io.inverno.mod.security.jose.jwk.X509JWK;
import io.inverno.mod.security.jose.jwk.X509JWKBuilder;
import io.inverno.mod.security.jose.jwk.X509JWKCertPathValidator;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractX509JWKBuilder<A extends PublicKey, B extends PrivateKey, C extends X509JWK<A, B>, D extends AbstractX509JWKBuilder<A, B, C, D>>
extends AbstractJWKBuilder<C, D>
implements X509JWKBuilder<A, B, C, D> {
    protected final JWKURLResolver urlResolver;
    protected final X509JWKCertPathValidator certPathValidator;
    protected URI x5u;
    protected String[] x5c;
    protected String x5t;
    protected String x5t_S256;
    protected volatile boolean keyTrusted;
    protected volatile X509Certificate certificate;

    public AbstractX509JWKBuilder(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, JWKURLResolver urlResolver, X509JWKCertPathValidator certPathValidator) {
        this(configuration, jwkStore, keyResolver, urlResolver, certPathValidator, null);
    }

    public AbstractX509JWKBuilder(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, JWKURLResolver urlResolver, X509JWKCertPathValidator certPathValidator, Map<String, Object> parameters) throws JWKReadException {
        super(configuration, jwkStore, keyResolver, parameters);
        this.certPathValidator = certPathValidator;
        this.urlResolver = urlResolver;
    }

    @Override
    protected void set(String name, Object value) throws JWKReadException {
        switch (name) {
            case "x5u": {
                if (value instanceof URI) {
                    this.x509CertificateURL((URI)value);
                    break;
                }
                if (value instanceof URL) {
                    try {
                        this.x509CertificateURL(((URL)value).toURI());
                        break;
                    }
                    catch (URISyntaxException e) {
                        throw new JWKReadException("Invalid x5u which must be a valid URI", e);
                    }
                }
                if (value instanceof CharSequence) {
                    this.x509CertificateURL(URI.create((String)value));
                    break;
                }
                throw new JWKReadException("x5u can't be converted to URI: " + value.getClass());
            }
            case "x5c": {
                if (value instanceof String[]) {
                    this.x509CertificateChain((String[])value);
                    break;
                }
                if (value instanceof Collection) {
                    this.x509CertificateChain((String[])((Collection)value).toArray(String[]::new));
                    break;
                }
                throw new JWKReadException("x5c can't be converted to String[]: " + value.getClass());
            }
            case "x5t": {
                this.x509CertificateSHA1Thumbprint((String)value);
                break;
            }
            case "x5t#S256": {
                this.x509CertificateSHA256Thumbprint((String)value);
                break;
            }
            default: {
                super.set(name, value);
            }
        }
    }

    @Override
    public D x509CertificateURL(URI x5u) {
        this.x5u = x5u;
        return (D)this;
    }

    @Override
    public D x509CertificateChain(String[] x5c) {
        this.x5c = x5c;
        return (D)this;
    }

    @Override
    public D x509CertificateSHA1Thumbprint(String x5t) {
        this.x5t = x5t;
        return (D)this;
    }

    @Override
    public D x509CertificateSHA256Thumbprint(String x5t_S256) {
        this.x5t_S256 = x5t_S256;
        return (D)this;
    }

    @Override
    protected Mono<Void> resolve() throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return super.resolve().then(this.resolveKid()).then(this.resolveX5t_S256()).then(this.resolveX5t()).then(Mono.fromRunnable(() -> {
            this.keyTrusted = this.key != null && this.certificate != null;
        })).then(this.resolveX5c()).then(this.resolveX5u()).then();
    }

    @Override
    protected Mono<JWK> resolveFromJWKStore() throws JWKResolveException {
        return super.resolveFromJWKStore().switchIfEmpty(Mono.defer(() -> this.jwkStore.getBy509CertificateSHA1Thumbprint(this.x5t))).switchIfEmpty(Mono.defer(() -> this.jwkStore.getByX509CertificateSHA256Thumbprint(this.x5t_S256)));
    }

    private Mono<Void> resolveKid() throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return this.keyResolver.resolveCertificateFromKeyId(this.kid).flatMap(tmpCert -> this.resolveCertificate((X509Certificate)tmpCert).doOnSuccess(ign -> {
            this.certificate = tmpCert;
        }));
    }

    private Mono<Void> resolveX5t() throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return Flux.merge((Publisher[])new Publisher[]{this.keyResolver.resolveKeyFromX509CertificateSHA1Thumbprint(this.x5t).flatMap(tmpKey -> this.resolveKey((Key)tmpKey).doOnSuccess(ign -> {
            if (this.key != null && !this.key.equals(tmpKey)) {
                throw new JWKBuildException("Resolved private key does not match previously resolved key");
            }
            this.key = tmpKey;
        })), this.keyResolver.resolveCertificateFromX509CertificateSHA1Thumbprint(this.x5t).flatMap(tmpCert -> this.resolveCertificate((X509Certificate)tmpCert).doOnSuccess(ign -> {
            this.certificate = tmpCert;
        }))}).then();
    }

    private Mono<Void> resolveX5t_S256() throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return Flux.merge((Publisher[])new Publisher[]{this.keyResolver.resolveKeyFromX509CertificateSHA1Thumbprint(this.x5t).flatMap(tmpKey -> this.resolveKey((Key)tmpKey).doOnSuccess(ign -> {
            if (this.key != null && !this.key.equals(tmpKey)) {
                throw new JWKBuildException("Resolved private key does not match previously resolved key");
            }
            this.key = tmpKey;
        })), this.keyResolver.resolveCertificateFromX509CertificateSHA1Thumbprint(this.x5t).flatMap(tmpCert -> this.resolveCertificate((X509Certificate)tmpCert).doOnSuccess(ign -> {
            this.certificate = tmpCert;
        }))}).then();
    }

    protected Mono<Void> resolveCertificate(X509Certificate certificate) throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return Mono.justOrEmpty((Object)certificate).flatMap(tmpCert -> {
            if (tmpCert.getKeyUsage() != null) {
                boolean[] keyUsage = tmpCert.getKeyUsage();
                if (this.use != null) {
                    if (this.use.equals("sig") && !keyUsage[0] || this.use.equals("enc") && !keyUsage[2] && !keyUsage[3]) {
                        throw new JWKBuildException("Resolved X.509 certificate algorithm key usage does not match JWK public key use");
                    }
                } else if (keyUsage[0]) {
                    this.use = "sig";
                } else if (keyUsage[2] || keyUsage[3]) {
                    this.use = "enc";
                }
                if (this.key_ops != null) {
                    if ((this.key_ops.contains("encrypt") || this.key_ops.contains("decrypt")) && !keyUsage[3] || (this.key_ops.contains("wrapKey") || this.key_ops.contains("unwrapKey")) && !keyUsage[2]) {
                        throw new JWKBuildException("Resolved X.509 certificate algorithm key usage does not match JWK public key use");
                    }
                } else if (keyUsage[2]) {
                    this.key_ops = Set.of("wrapKey", "unwrapKey");
                } else if (keyUsage[3]) {
                    this.key_ops = Set.of("encrypt", "decrypt");
                }
            }
            return Mono.empty();
        });
    }

    private Mono<Void> resolveX5u() throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return this.urlResolver.resolveX509CertificateURL(this.x5u).filter(certs -> !certs.isEmpty()).flatMap(certs -> this.configuration.validate_certificate() ? this.certPathValidator.validate((List<X509Certificate>)certs) : Mono.just((Object)((X509Certificate)certs.get(0)))).flatMap(tmpCert -> this.resolveCertificate((X509Certificate)tmpCert).doOnSuccess(ign -> {
            this.certificate = tmpCert;
        }));
    }

    private Mono<Void> resolveX5c() throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return Mono.justOrEmpty((Object)this.x5c).filter(certs -> ((String[])certs).length > 0).flatMap(certs -> {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
                for (String encodedCert : certs) {
                    certificates.add((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(encodedCert))));
                }
                return this.configuration.validate_certificate() ? this.certPathValidator.validate(certificates) : Mono.just((Object)((X509Certificate)certificates.get(0)));
            }
            catch (CertificateException e) {
                throw new JWKBuildException("Error resolving X.509 certificate chain", e);
            }
        }).flatMap(tmpCert -> this.resolveCertificate((X509Certificate)tmpCert).doOnSuccess(ign -> {
            this.certificate = tmpCert;
        }));
    }
}

