/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.internal.jwk.AbstractJWK;
import io.inverno.mod.security.jose.internal.jwk.AbstractJWKBuilder;
import io.inverno.mod.security.jose.internal.jwk.AbstractJWKGenerator;
import io.inverno.mod.security.jose.jwk.JWKBuildException;
import io.inverno.mod.security.jose.jwk.JWKFactory;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.JWKReadException;
import io.inverno.mod.security.jose.jwk.JWKResolveException;
import io.inverno.mod.security.jose.jwk.JWKStore;
import java.util.Map;
import reactor.core.publisher.Mono;

public abstract class AbstractJWKFactory<A extends AbstractJWK, B extends AbstractJWKBuilder<A, B>, C extends AbstractJWKGenerator<A, C>>
implements JWKFactory<A, B, C> {
    protected final JOSEConfiguration configuration;
    protected final JWKStore jwkStore;
    protected final JWKKeyResolver keyResolver;
    protected final ObjectMapper mapper;

    public AbstractJWKFactory(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, ObjectMapper mapper) {
        this.configuration = configuration;
        this.jwkStore = jwkStore;
        this.keyResolver = keyResolver;
        this.mapper = mapper;
    }

    @Override
    public Mono<A> read(String jwk) throws JWKReadException, JWKBuildException, JWKResolveException, JWKProcessingException {
        try {
            return this.read((Map)this.mapper.readerFor(Object.class).readValue(jwk));
        }
        catch (JsonProcessingException e) {
            throw new JWKReadException("Error reading JWK", e);
        }
        catch (ClassCastException e) {
            throw new JWKReadException("Invalid JWK string", e);
        }
    }

    @Override
    public Mono<A> read(Map<String, Object> jwk) throws JWKReadException, JWKBuildException, JWKResolveException, JWKProcessingException {
        return ((AbstractJWKBuilder)this.builder(jwk)).build();
    }

    @Override
    public Mono<A> generate(String alg, Map<String, Object> parameters) throws JWKGenerateException, JWKProcessingException {
        return ((AbstractJWKGenerator)this.generator(alg, parameters)).generate();
    }

    public abstract B builder(Map<String, Object> var1);

    public abstract C generator(String var1, Map<String, Object> var2);
}

