/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwe;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEBuilder;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEHeader;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEPayload;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWACipherException;
import io.inverno.mod.security.jose.jwe.JWEBuildException;
import io.inverno.mod.security.jose.jwe.JWEZip;
import io.inverno.mod.security.jose.jwe.JWEZipException;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.JWKService;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RecipientJWEBuilder<A>
extends GenericJWEBuilder<A> {
    private final GenericJWEHeader protectedJWEHeader;
    private final GenericJWEHeader recipientJWEHeader;
    private final GenericJWEHeader jweHeader;
    private final Mono<GenericJWEPayload<A>> jwePayload;
    private final byte[] aad;
    private final JWACipher.EncryptedData zipAndEncryptedPayload;
    private final Flux<? extends JWK> cek;

    public RecipientJWEBuilder(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys, List<JWEZip> zips, GenericJWEHeader protectedJWEHeader, GenericJWEHeader recipientJWEHeader, GenericJWEHeader jweHeader, GenericJWEPayload<A> jwePayload, byte[] aad) {
        this(mapper, dataConversionService, jwkService, type, keys, zips, protectedJWEHeader, recipientJWEHeader, jweHeader, jwePayload, aad, null, null);
    }

    public RecipientJWEBuilder(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys, List<JWEZip> zips, GenericJWEHeader protectedJWEHeader, GenericJWEHeader recipientJWEHeader, GenericJWEHeader jweHeader, GenericJWEPayload<A> jwePayload, byte[] aad, JWK cek, JWACipher.EncryptedData zipAndEncryptedPayload) {
        super(mapper, dataConversionService, jwkService, type, keys, zips);
        this.protectedJWEHeader = protectedJWEHeader;
        this.recipientJWEHeader = recipientJWEHeader;
        this.jweHeader = jweHeader;
        this.jwePayload = Mono.just(jwePayload);
        this.aad = aad;
        this.zipAndEncryptedPayload = zipAndEncryptedPayload;
        this.cek = cek != null ? Flux.just((Object)cek) : null;
    }

    @Override
    public GenericJWEBuilder<A> header(Consumer<GenericJWEHeader> configurer) {
        throw new IllegalStateException();
    }

    @Override
    public GenericJWEBuilder<A> payload(A payload) {
        throw new IllegalStateException();
    }

    @Override
    protected GenericJWEHeader buildJWEHeader() throws JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        this.checkHeader(this.jweHeader);
        this.jweHeader.setEncoded(this.protectedJWEHeader != null ? this.protectedJWEHeader.getEncoded() : "");
        return this.jweHeader;
    }

    @Override
    protected Mono<GenericJWEPayload<A>> buildJWEPayload(Function<A, Mono<String>> overridingPayloadEncoder, String overridingContentType, GenericJWEHeader jweHeader) throws JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        return this.jwePayload;
    }

    @Override
    protected Flux<? extends JWK> generateCEK(GenericJWEHeader jweHeader) throws JWKGenerateException {
        if (this.cek != null) {
            return this.cek;
        }
        return super.generateCEK(jweHeader);
    }

    @Override
    protected void amendJWEHeader(GenericJWEHeader header, Map<String, Object> moreHeaderParameters, Set<String> processedParameters) throws JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        if (moreHeaderParameters != null && this.recipientJWEHeader != null) {
            moreHeaderParameters.forEach((k, v) -> this.recipientJWEHeader.addCustomParameter((String)k, v));
        }
        super.amendJWEHeader(header, moreHeaderParameters, processedParameters);
    }

    @Override
    protected byte[] getAdditionalAuthenticationData(GenericJWEHeader jweHeader) {
        return this.aad;
    }

    @Override
    protected JWACipher.EncryptedData zipAndEncryptPayload(GenericJWEHeader jweHeader, GenericJWEPayload<A> jwePayload, JWEZip payloadZip, JWK cek) throws JWKProcessingException, JWEZipException, JWACipherException {
        if (this.zipAndEncryptedPayload != null) {
            return this.zipAndEncryptedPayload;
        }
        return super.zipAndEncryptPayload(jweHeader, jwePayload, payloadZip, cek);
    }
}

