/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwe;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEHeader;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JsonJWEHeader
extends GenericJWEHeader {
    private final Set<String> parametersSet = new HashSet<String>();

    public JsonJWEHeader() {
    }

    public JsonJWEHeader(String alg, String enc) {
        super(alg, enc);
    }

    public JsonJWEHeader merge(JsonJWEHeader header) {
        if (header != null) {
            if (header.alg != null) {
                this.alg = header.alg;
            }
            if (header.zip != null) {
                this.zip = header.zip;
            }
            if (header.cty != null) {
                this.cty = header.cty;
            }
            if (header.crit != null) {
                this.crit = header.crit;
            }
            if (header.customParameters != null) {
                if (this.customParameters == null) {
                    this.customParameters = new HashMap();
                }
                this.customParameters.putAll(header.customParameters);
            }
            if (header.enc != null) {
                this.enc = header.enc;
            }
            if (header.jwk != null) {
                this.jwk = header.jwk;
            }
            if (header.jku != null) {
                this.jku = header.jku;
            }
            if (header.getKeyId() != null) {
                this.kid = header.getKeyId();
            }
            if (header.typ != null) {
                this.typ = header.typ;
            }
            if (header.x5c != null) {
                this.x5c = header.x5c;
            }
            if (header.x5t != null) {
                this.x5t = header.x5t;
            }
            if (header.x5t_S256 != null) {
                this.x5t_S256 = header.x5t_S256;
            }
            if (header.x5u != null) {
                this.x5u = header.x5u;
            }
        }
        return this;
    }

    @JsonIgnore
    public Set<String> getParametersSet() {
        return this.parametersSet;
    }

    @Override
    public JsonJWEHeader algorithm(String alg) {
        this.parametersSet.add("alg");
        return (JsonJWEHeader)super.algorithm(alg);
    }

    @Override
    public JsonJWEHeader jwkSetURL(URI jku) {
        this.parametersSet.add("jku");
        return (JsonJWEHeader)super.jwkSetURL(jku);
    }

    @Override
    public JsonJWEHeader jwk(Map<String, Object> jwk) {
        this.parametersSet.add("jwk");
        return (JsonJWEHeader)super.jwk((Map)jwk);
    }

    @Override
    public JsonJWEHeader keyId(String kid) {
        this.parametersSet.add("kid");
        return (JsonJWEHeader)super.keyId(kid);
    }

    @Override
    public JsonJWEHeader x509CertificateURL(URI x5u) {
        this.parametersSet.add("x5u");
        return (JsonJWEHeader)super.x509CertificateURL(x5u);
    }

    @Override
    public JsonJWEHeader x509CertificateChain(String[] x5c) {
        this.parametersSet.add("x5c");
        return (JsonJWEHeader)super.x509CertificateChain(x5c);
    }

    @Override
    public JsonJWEHeader x509CertificateSHA1Thumbprint(String x5t) {
        this.parametersSet.add("x5t");
        return (JsonJWEHeader)super.x509CertificateSHA1Thumbprint(x5t);
    }

    @Override
    public JsonJWEHeader x509CertificateSHA256Thumbprint(String x5t_S256) {
        this.parametersSet.add("x5t#S256");
        return (JsonJWEHeader)super.x509CertificateSHA256Thumbprint(x5t_S256);
    }

    @Override
    public JsonJWEHeader type(String typ) {
        this.parametersSet.add("typ");
        return (JsonJWEHeader)super.type(typ);
    }

    @Override
    public JsonJWEHeader contentType(String cty) {
        this.parametersSet.add("cty");
        return (JsonJWEHeader)super.contentType(cty);
    }

    @Override
    public JsonJWEHeader critical(String ... crit) {
        this.parametersSet.add("crit");
        return (JsonJWEHeader)super.critical(crit);
    }

    @Override
    public JsonJWEHeader addCustomParameter(String key, Object value) {
        this.parametersSet.add(key);
        return (JsonJWEHeader)super.addCustomParameter(key, value);
    }

    @Override
    public JsonJWEHeader encryptionAlgorithm(String enc) {
        this.enc = enc;
        return this;
    }

    @Override
    public JsonJWEHeader compressionAlgorithm(String zip) {
        this.zip = zip;
        return this;
    }
}

