/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwe;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.AbstractJOSEObjectReader;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jwe.GenericJWE;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEHeader;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEPayload;
import io.inverno.mod.security.jose.jwa.DirectJWAKeyManager;
import io.inverno.mod.security.jose.jwa.EncryptingJWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.NoAlgorithm;
import io.inverno.mod.security.jose.jwa.WrappingJWAKeyManager;
import io.inverno.mod.security.jose.jwe.JWE;
import io.inverno.mod.security.jose.jwe.JWEBuildException;
import io.inverno.mod.security.jose.jwe.JWEHeader;
import io.inverno.mod.security.jose.jwe.JWEReadException;
import io.inverno.mod.security.jose.jwe.JWEReader;
import io.inverno.mod.security.jose.jwe.JWEZip;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GenericJWEReader<A>
extends AbstractJOSEObjectReader<A, JWEHeader, JWE<A>, GenericJWEReader<A>>
implements JWEReader<A, GenericJWEReader<A>> {
    private static final Logger LOGGER = LogManager.getLogger(GenericJWEReader.class);
    private final List<JWEZip> zips;

    public GenericJWEReader(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys, List<JWEZip> zips) {
        super(mapper, dataConversionService, jwkService, type, keys);
        this.zips = zips;
    }

    @Override
    public Mono<JWE<A>> read(String compact, String contentType) throws JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        return this.read(compact, null, contentType);
    }

    @Override
    public Mono<JWE<A>> read(String compact, Function<String, Mono<A>> payloadDecoder) throws JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        return this.read(compact, payloadDecoder, null);
    }

    private Mono<JWE<A>> read(String compact, Function<String, Mono<A>> overridingPayloadDecoder, String overridingContentType) throws JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        String[] jweParts = compact.split("\\.", -1);
        if (jweParts.length != 5) {
            throw new JWEReadException("Invalid compact JWE");
        }
        GenericJWEHeader jweHeader = this.readJWEHeader(jweParts[0]);
        return this.read(jweHeader, jweParts[1], jweParts[2], jweParts[3], jweParts[4], this.getKeys(jweHeader), this.getPayloadDecoder(overridingPayloadDecoder, overridingContentType, jweHeader));
    }

    private Mono<JWE<A>> read(GenericJWEHeader jweHeader, String encodedEncryptedKey, String encodedInitializationVector, String encodedCipherText, String encodedAuthenticationTag, Flux<? extends JWK> keys, Function<String, Mono<A>> payloadDecoder) throws JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        if (StringUtils.isBlank((CharSequence)encodedCipherText)) {
            throw new JWEReadException("Payload is blank");
        }
        JWEZip payloadZip = this.getPayloadZip(jweHeader.getCompressionAlgorithm());
        byte[] iv = Base64.getUrlDecoder().decode(encodedInitializationVector);
        byte[] cipherText = Base64.getUrlDecoder().decode(encodedCipherText);
        byte[] tag = Base64.getUrlDecoder().decode(encodedAuthenticationTag);
        byte[] aad = this.getAdditionalAuthenticationData(jweHeader);
        if (jweHeader.getAlgorithm().equals(NoAlgorithm.DIR.getAlgorithm())) {
            if (StringUtils.isNotBlank((CharSequence)encodedEncryptedKey)) {
                throw new JWEReadException("Direct encryption JWE has a non-blank encrypted key");
            }
            return Mono.defer(() -> {
                JWEReadException error = new JWEReadException("Failed to read JWE");
                return keys.onErrorStop().flatMap(key -> {
                    JWACipher cipher = key.cipher(jweHeader.getEncryptionAlgorithm());
                    this.checkCriticalParameters(jweHeader.getCritical(), cipher);
                    byte[] decryptedPayload = cipher.decrypt(cipherText, aad, iv, tag);
                    String payloadRaw = payloadZip != null ? new String(payloadZip.decompress(decryptedPayload)) : new String(decryptedPayload);
                    return ((Mono)payloadDecoder.apply(payloadRaw)).map(payload -> {
                        GenericJWEPayload<Object> jwePayload = new GenericJWEPayload<Object>(payload);
                        jwePayload.setRaw(payloadRaw);
                        jwePayload.setEncoded(encodedCipherText);
                        return new GenericJWE<Object>(jweHeader, jwePayload, encodedInitializationVector, encodedAuthenticationTag);
                    });
                }).onErrorContinue((e, key) -> {
                    error.addSuppressed((Throwable)e);
                    LOGGER.debug(() -> "Failed to read JWE with key: " + key, e);
                }).next().switchIfEmpty(Mono.error((Throwable)error));
            });
        }
        return Mono.defer(() -> {
            JWEReadException error = new JWEReadException("Failed to read JWE");
            return keys.onErrorStop().flatMap(key -> {
                JWK cek;
                JWAKeyManager keyManager = key.keyManager(jweHeader.getAlgorithm());
                if (keyManager instanceof DirectJWAKeyManager) {
                    if (StringUtils.isNotBlank((CharSequence)encodedEncryptedKey)) {
                        throw new JWEReadException("Direct encryption JWE has a non-blank encrypted key");
                    }
                    DirectJWAKeyManager.DirectCEK directCEK = ((DirectJWAKeyManager)keyManager).deriveCEK(jweHeader.getEncryptionAlgorithm(), jweHeader.getCustomParameters());
                    Map<String, Object> moreHeaderParameters = directCEK.getMoreHeaderParameters();
                    if (moreHeaderParameters != null) {
                        jweHeader.getCustomParameters().putAll(moreHeaderParameters);
                    }
                    cek = directCEK.getEncryptionKey();
                } else {
                    byte[] decodedEncryptedKey = Base64.getUrlDecoder().decode(encodedEncryptedKey);
                    if (keyManager instanceof EncryptingJWAKeyManager) {
                        if (decodedEncryptedKey.length == 0) {
                            throw new JWEReadException("Failed to decrypt JWE because encrypted key is blank and an encrypting key manager was returned by the key");
                        }
                        cek = ((EncryptingJWAKeyManager)keyManager).decryptCEK(decodedEncryptedKey, jweHeader.getEncryptionAlgorithm(), jweHeader.getCustomParameters());
                    } else if (keyManager instanceof WrappingJWAKeyManager) {
                        if (decodedEncryptedKey.length == 0) {
                            throw new JWEReadException("Failed to decrypt JWE because encrypted key is blank and a wrapping key manager was returned by the key");
                        }
                        cek = ((WrappingJWAKeyManager)keyManager).unwrapCEK(decodedEncryptedKey, jweHeader.getEncryptionAlgorithm(), jweHeader.getCustomParameters());
                    } else {
                        throw new JWAProcessingException("Key manager must implement " + DirectJWAKeyManager.class + ", " + EncryptingJWAKeyManager.class + " or " + WrappingJWAKeyManager.class);
                    }
                }
                JWACipher cipher = cek.cipher(jweHeader.getEncryptionAlgorithm());
                this.checkCriticalParameters(jweHeader.getCritical(), keyManager, cipher);
                byte[] decryptedPayload = cipher.decrypt(cipherText, aad, iv, tag);
                String payloadRaw = payloadZip != null ? new String(payloadZip.decompress(decryptedPayload)) : new String(decryptedPayload);
                return ((Mono)payloadDecoder.apply(payloadRaw)).map(payload -> {
                    GenericJWEPayload<Object> jwePayload = new GenericJWEPayload<Object>(payload);
                    jwePayload.setRaw(payloadRaw);
                    jwePayload.setEncoded(encodedCipherText);
                    return new GenericJWE<Object>(jweHeader, jwePayload, encodedInitializationVector, encodedAuthenticationTag, encodedEncryptedKey.isBlank() ? null : encodedEncryptedKey, cek);
                });
            }).onErrorContinue((e, key) -> {
                error.addSuppressed((Throwable)e);
                LOGGER.debug(() -> "Failed to read JWE with key: " + key, e);
            }).next().switchIfEmpty(Mono.error((Throwable)error));
        });
    }

    @Override
    protected void checkHeader(JWEHeader header) throws JWEReadException, JOSEObjectReadException {
        super.checkHeader(header);
        if (StringUtils.isBlank((CharSequence)header.getEncryptionAlgorithm())) {
            throw new JWEReadException("Encryption algorithm is blank");
        }
    }

    protected GenericJWEHeader readJWEHeader(String encodedHeader) throws JWEReadException, JOSEObjectReadException, JOSEProcessingException {
        try {
            GenericJWEHeader jweHeader = (GenericJWEHeader)this.mapper.readValue(Base64.getUrlDecoder().decode(encodedHeader), GenericJWEHeader.class);
            this.checkHeader(jweHeader);
            jweHeader.setEncoded(encodedHeader);
            return jweHeader;
        }
        catch (IOException e) {
            throw new JWEReadException("Failed to read JWE header", e);
        }
    }

    protected byte[] getAdditionalAuthenticationData(GenericJWEHeader jweHeader) {
        return jweHeader.getEncoded().getBytes(StandardCharsets.US_ASCII);
    }

    protected JWEZip getPayloadZip(String zip) throws JWEReadException {
        if (StringUtils.isBlank((CharSequence)zip)) {
            return null;
        }
        return this.zips.stream().filter(z -> z.supports(zip)).findFirst().orElseThrow(() -> new JWEReadException("No JWE zip found supporting compression algorithm: " + zip));
    }
}

