/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwe;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.inverno.mod.security.jose.internal.AbstractJOSEHeader;
import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.jwe.JWEHeader;
import io.inverno.mod.security.jose.jwe.JWEHeaderConfigurator;
import java.util.Base64;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GenericJWEHeader
extends AbstractJOSEHeader<GenericJWEHeader>
implements JWEHeader,
JWEHeaderConfigurator<GenericJWEHeader> {
    public static final Set<String> PROCESSED_PARAMETERS = Stream.concat(AbstractJOSEHeader.PROCESSED_PARAMETERS.stream(), Stream.of("enc", "zip")).collect(Collectors.toSet());
    protected String enc;
    protected String zip;
    private byte[] raw;
    private Set<String> processedParameters;

    public GenericJWEHeader() {
        this.processedParameters = PROCESSED_PARAMETERS;
    }

    public GenericJWEHeader(String alg, String enc) {
        super(alg);
        this.enc = enc;
        this.processedParameters = PROCESSED_PARAMETERS;
    }

    public void setExtraProcessedParameters(Set<String> extraParameters) {
        if (extraParameters == null || extraParameters.isEmpty()) {
            this.processedParameters = PROCESSED_PARAMETERS;
        } else {
            this.processedParameters = new HashSet<String>(PROCESSED_PARAMETERS);
            this.processedParameters.addAll(extraParameters);
        }
    }

    @Override
    public void setEncoded(String encoded) {
        super.setEncoded(encoded);
        this.raw = Base64.getUrlDecoder().decode(encoded);
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
        this.encoded = raw != null ? JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(raw) : null;
    }

    @JsonIgnore
    public byte[] getRaw() {
        return this.raw;
    }

    @Override
    public Set<String> getProcessedParameters() {
        return this.processedParameters;
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.enc;
    }

    @Override
    public String getCompressionAlgorithm() {
        return this.zip;
    }

    @Override
    @JsonSetter(value="enc")
    public GenericJWEHeader encryptionAlgorithm(String enc) {
        this.enc = enc;
        return this;
    }

    @Override
    @JsonSetter(value="zip")
    public GenericJWEHeader compressionAlgorithm(String zip) {
        this.zip = zip;
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.enc, this.zip);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericJWEHeader other = (GenericJWEHeader)obj;
        return Objects.equals(this.enc, other.enc) && Objects.equals(this.zip, other.zip);
    }
}

