/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwe;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.security.jose.jwe.JWEZip;
import io.inverno.mod.security.jose.jwe.JWEZipException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class DeflateJWEZip
implements JWEZip {
    @Override
    public boolean supports(String zip) {
        return zip.equals("DEF");
    }

    @Override
    public byte[] compress(byte[] data) throws JWEZipException {
        Deflater deflater = new Deflater(8, true);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (DeflaterOutputStream deflaterOutput = new DeflaterOutputStream((OutputStream)output, deflater);){
            deflaterOutput.write(data);
        }
        catch (IOException e) {
            throw new JWEZipException(e);
        }
        finally {
            deflater.end();
        }
        return output.toByteArray();
    }

    @Override
    public byte[] decompress(byte[] data) throws JWEZipException {
        Inflater inflater = new Inflater(true);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (InflaterInputStream inflaterInput = new InflaterInputStream(new ByteArrayInputStream(data), inflater);){
            int len;
            byte[] b = new byte[1024];
            while ((len = inflaterInput.read(b)) > 0) {
                output.write(b, 0, len);
            }
        }
        catch (IOException e) {
            throw new JWEZipException(e);
        }
        finally {
            inflater.end();
        }
        return output.toByteArray();
    }
}

