/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.jwa.AbstractJWASigner;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.JWASignatureException;
import io.inverno.mod.security.jose.jwa.RSAAlgorithm;
import io.inverno.mod.security.jose.jwk.rsa.RSAJWK;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;

public class RSASigner
extends AbstractJWASigner<RSAJWK, RSAAlgorithm> {
    public static final Set<RSAAlgorithm> SUPPORTED_ALGORITHMS = Set.of(RSAAlgorithm.RS1, RSAAlgorithm.RS256, RSAAlgorithm.RS384, RSAAlgorithm.RS512, RSAAlgorithm.PS256, RSAAlgorithm.PS384, RSAAlgorithm.PS512);

    public RSASigner(RSAJWK jwk, RSAAlgorithm algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
        if (!SUPPORTED_ALGORITHMS.contains(algorithm)) {
            throw new JWAProcessingException("Unsupported algorithm: " + algorithm.getAlgorithm());
        }
        this.init();
    }

    protected RSASigner(RSAJWK jwk) {
        super(jwk);
    }

    @Override
    protected final void init() throws JWAProcessingException {
    }

    @Override
    protected byte[] doSign(byte[] data) throws JWASignatureException {
        return ((RSAJWK)this.jwk).toPrivateKey().map(privateKey -> {
            try {
                Signature sig = Signature.getInstance(((RSAAlgorithm)this.algorithm).getJcaAlgorithm());
                AlgorithmParameterSpec signatureParameter = ((RSAAlgorithm)this.algorithm).getSignatureParameter();
                if (signatureParameter != null) {
                    sig.setParameter(signatureParameter);
                }
                sig.initSign((PrivateKey)privateKey);
                sig.update(data);
                return sig.sign();
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                throw new JWASignatureException(e);
            }
        }).orElseThrow(() -> new JWASignatureException("JWK is missing RSA private exponent"));
    }

    @Override
    protected boolean doVerify(byte[] data, byte[] signature) throws JWASignatureException {
        try {
            Signature sig = Signature.getInstance(((RSAAlgorithm)this.algorithm).getJcaAlgorithm());
            AlgorithmParameterSpec signatureParameter = ((RSAAlgorithm)this.algorithm).getSignatureParameter();
            if (signatureParameter != null) {
                sig.setParameter(signatureParameter);
            }
            sig.initVerify((PublicKey)((RSAJWK)this.jwk).toPublicKey());
            sig.update(data);
            return sig.verify(signature);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWASignatureException(e);
        }
    }
}

