/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwa.AbstractEncryptingJWAKeyManager;
import io.inverno.mod.security.jose.internal.jwa.GenericEncryptedCEK;
import io.inverno.mod.security.jose.internal.jwk.oct.GenericOCTJWK;
import io.inverno.mod.security.jose.jwa.EncryptingJWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAKeyManagerException;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwa.RSAAlgorithm;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import io.inverno.mod.security.jose.jwk.rsa.RSAJWK;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidParameterSpecException;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAKeyManager
extends AbstractEncryptingJWAKeyManager<RSAJWK, RSAAlgorithm> {
    public static final Set<RSAAlgorithm> SUPPORTED_ALGORITHMS = Set.of(RSAAlgorithm.RSA1_5, RSAAlgorithm.RSA_OAEP, RSAAlgorithm.RSA_OAEP_256, RSAAlgorithm.RSA_OAEP_384, RSAAlgorithm.RSA_OAEP_512);

    public RSAKeyManager(RSAJWK jwk, RSAAlgorithm algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
        if (!SUPPORTED_ALGORITHMS.contains(algorithm)) {
            throw new JWAProcessingException("Unsupported algorithm: " + algorithm.getAlgorithm());
        }
        this.init();
    }

    protected RSAKeyManager(RSAJWK jwk) {
        super(jwk);
    }

    @Override
    protected final void init() throws JWAProcessingException {
    }

    @Override
    protected EncryptingJWAKeyManager.EncryptedCEK doEncryptCEK(OCTJWK cek, Map<String, Object> parameters, SecureRandom secureRandom) throws JWAKeyManagerException {
        try {
            Cipher cipher = Cipher.getInstance(((RSAAlgorithm)this.algorithm).getJcaAlgorithm());
            if (((RSAAlgorithm)this.algorithm).getSignatureParameter() != null) {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("OAEP");
                algorithmParameters.init(((RSAAlgorithm)this.algorithm).getSignatureParameter());
                cipher.init(1, (Key)((RSAJWK)this.jwk).toPublicKey(), algorithmParameters, secureRandom);
            } else {
                cipher.init(1, (Key)((RSAJWK)this.jwk).toPublicKey(), secureRandom);
            }
            byte[] encryptedKey = cipher.doFinal(Base64.getUrlDecoder().decode(cek.getKeyValue()));
            return new GenericEncryptedCEK(encryptedKey);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new JWAKeyManagerException(e);
        }
    }

    @Override
    protected OCTJWK doDecryptCEK(byte[] encrypted_key, OCTAlgorithm octEnc, Map<String, Object> parameters) throws JWAKeyManagerException {
        return ((RSAJWK)this.jwk).toPrivateKey().map(privateKey -> {
            try {
                Cipher cipher = Cipher.getInstance(((RSAAlgorithm)this.algorithm).getJcaAlgorithm());
                if (((RSAAlgorithm)this.algorithm).getSignatureParameter() != null) {
                    AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("OAEP");
                    algorithmParameters.init(((RSAAlgorithm)this.algorithm).getSignatureParameter());
                    cipher.init(2, (Key)privateKey, algorithmParameters);
                } else {
                    cipher.init(2, (Key)privateKey);
                }
                GenericOCTJWK cek = new GenericOCTJWK(JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(cipher.doFinal(encrypted_key)));
                cek.setAlgorithm(octEnc);
                return cek;
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw new JWAKeyManagerException(e);
            }
        }).orElseThrow(() -> new JWAKeyManagerException("JWK is missing RSA private exponent"));
    }
}

