/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.jwa.AbstractJWASigner;
import io.inverno.mod.security.jose.jwa.EdECAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.JWASignatureException;
import io.inverno.mod.security.jose.jwk.okp.EdECJWK;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class EdDSASigner
extends AbstractJWASigner<EdECJWK, EdECAlgorithm> {
    public EdDSASigner(EdECJWK jwk, EdECAlgorithm algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
        if (!jwk.getCurve().equals(algorithm.getCurve().getCurve())) {
            throw new JWAProcessingException("JWK with curve " + jwk.getCurve() + " does not support algorithm " + algorithm);
        }
    }

    protected EdDSASigner(EdECJWK jwk) {
        super(jwk);
    }

    @Override
    protected final void init() throws JWAProcessingException {
    }

    @Override
    protected byte[] doSign(byte[] data) throws JWASignatureException {
        return ((EdECJWK)this.jwk).toPrivateKey().map(privateKey -> {
            try {
                Signature sig = Signature.getInstance(((EdECAlgorithm)this.algorithm).getJcaAlgorithm());
                sig.initSign((PrivateKey)privateKey);
                sig.update(data);
                return sig.sign();
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                throw new JWASignatureException(e);
            }
        }).orElseThrow(() -> new JWASignatureException("JWK is missing OKP private key"));
    }

    @Override
    protected boolean doVerify(byte[] data, byte[] signature) throws JWASignatureException {
        try {
            Signature sig = Signature.getInstance(((EdECAlgorithm)this.algorithm).getJcaAlgorithm());
            sig.initVerify((PublicKey)((EdECJWK)this.jwk).toPublicKey());
            sig.update(data);
            return sig.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWASignatureException(e);
        }
    }
}

