/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwa.AbstractJWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAKeyManagerException;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwa.WrappingJWAKeyManager;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import java.security.SecureRandom;
import java.util.Map;

public abstract class AbstractWrappingJWAKeyManager<A extends JWK, B extends JWAAlgorithm<A>>
extends AbstractJWAKeyManager<A, B>
implements WrappingJWAKeyManager {
    public AbstractWrappingJWAKeyManager(A jwk, B algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
    }

    protected AbstractWrappingJWAKeyManager(A jwk) {
        super(jwk);
    }

    @Override
    public WrappingJWAKeyManager.WrappedCEK wrapCEK(JWK cek, Map<String, Object> parameters, SecureRandom secureRandom) throws JWAKeyManagerException {
        if (this.jwk.getKeyOperations() != null && !this.jwk.getKeyOperations().contains("wrapKey")) {
            throw new JWAKeyManagerException("JWK does not support wrap key operations");
        }
        if (!(cek instanceof OCTJWK)) {
            throw new JWAKeyManagerException("Unsupported CEK type: " + cek.getClass());
        }
        return this.doWrapCEK((OCTJWK)cek, parameters, secureRandom != null ? secureRandom : JOSEUtils.DEFAULT_SECURE_RANDOM);
    }

    protected abstract WrappingJWAKeyManager.WrappedCEK doWrapCEK(OCTJWK var1, Map<String, Object> var2, SecureRandom var3) throws JWAKeyManagerException;

    @Override
    public JWK unwrapCEK(byte[] encrypted_key, String enc, Map<String, Object> parameters) throws JWAKeyManagerException {
        OCTAlgorithm octEnc;
        if (this.jwk.getKeyOperations() != null && !this.jwk.getKeyOperations().contains("unwrapKey")) {
            throw new JWAKeyManagerException("JWK does not support unwrap key operations");
        }
        try {
            octEnc = OCTAlgorithm.fromAlgorithm(enc);
        }
        catch (IllegalArgumentException e) {
            throw new JWAKeyManagerException("Unsupported encryption algorithm: " + enc);
        }
        return this.doUnwrapCEK(encrypted_key, octEnc, parameters);
    }

    protected abstract OCTJWK doUnwrapCEK(byte[] var1, OCTAlgorithm var2, Map<String, Object> var3) throws JWAKeyManagerException;
}

