/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.jwa.AbstractJWA;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwk.JWK;

public abstract class AbstractJWAKeyManager<A extends JWK, B extends JWAAlgorithm<A>>
extends AbstractJWA
implements JWAKeyManager {
    protected final A jwk;
    protected B algorithm;

    public AbstractJWAKeyManager(A jwk, B algorithm) throws JWAProcessingException {
        if (!algorithm.isKeyManagement()) {
            throw new JWAProcessingException("Not a key management algorithm: " + algorithm.getAlgorithm());
        }
        this.jwk = jwk;
        this.algorithm = algorithm;
    }

    protected AbstractJWAKeyManager(A jwk) {
        this.jwk = jwk;
    }
}

