/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwa.AbstractJWAKeyManager;
import io.inverno.mod.security.jose.jwa.EncryptingJWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAKeyManagerException;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import java.security.SecureRandom;
import java.util.Map;

public abstract class AbstractEncryptingJWAKeyManager<A extends JWK, B extends JWAAlgorithm<A>>
extends AbstractJWAKeyManager<A, B>
implements EncryptingJWAKeyManager {
    public AbstractEncryptingJWAKeyManager(A jwk, B algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
    }

    protected AbstractEncryptingJWAKeyManager(A jwk) {
        super(jwk);
    }

    @Override
    public EncryptingJWAKeyManager.EncryptedCEK encryptCEK(JWK cek, Map<String, Object> parameters, SecureRandom secureRandom) throws JWAKeyManagerException {
        if (this.jwk.getKeyOperations() != null && !this.jwk.getKeyOperations().contains("encrypt")) {
            throw new JWAKeyManagerException("JWK does not support encrypt key operations");
        }
        if (!(cek instanceof OCTJWK)) {
            throw new JWAKeyManagerException("Unsupported CEK type: " + cek.getClass());
        }
        return this.doEncryptCEK((OCTJWK)cek, parameters, secureRandom != null ? secureRandom : JOSEUtils.DEFAULT_SECURE_RANDOM);
    }

    protected abstract EncryptingJWAKeyManager.EncryptedCEK doEncryptCEK(OCTJWK var1, Map<String, Object> var2, SecureRandom var3) throws JWAKeyManagerException;

    @Override
    public JWK decryptCEK(byte[] encrypted_key, String enc, Map<String, Object> parameters) throws JWAKeyManagerException {
        OCTAlgorithm octEnc;
        if (this.jwk.getKeyOperations() != null && !this.jwk.getKeyOperations().contains("decrypt")) {
            throw new JWAKeyManagerException("JWK does not support decrypt key operations");
        }
        try {
            octEnc = OCTAlgorithm.fromAlgorithm(enc);
        }
        catch (IllegalArgumentException e) {
            throw new JWAKeyManagerException("Unsupported encryption algorithm: " + enc);
        }
        return this.doDecryptCEK(encrypted_key, octEnc, parameters);
    }

    protected abstract OCTJWK doDecryptCEK(byte[] var1, OCTAlgorithm var2, Map<String, Object> var3) throws JWAKeyManagerException;
}

