/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.jwa.AESKWKeyManager;
import io.inverno.mod.security.jose.internal.jwa.AbstractWrappingJWAKeyManager;
import io.inverno.mod.security.jose.internal.jwa.GenericWrappedCEK;
import io.inverno.mod.security.jose.jwa.DirectJWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAKeyManagerException;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwa.WrappingJWAKeyManager;
import io.inverno.mod.security.jose.jwk.AsymmetricJWK;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractECDH_ES_AESKWKeyManager<A extends PublicKey, B extends PrivateKey, C extends AsymmetricJWK<A, B>, D extends JWAAlgorithm<C>>
extends AbstractWrappingJWAKeyManager<C, D> {
    public static final Set<String> PROCESSED_PARAMETERS = Set.of("epk", "apu", "apv");

    public AbstractECDH_ES_AESKWKeyManager(C jwk, D algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
    }

    public AbstractECDH_ES_AESKWKeyManager(C jwk) {
        super(jwk);
    }

    protected abstract OCTAlgorithm getCEKWrappingAlgorithm();

    protected abstract DirectJWAKeyManager.DirectCEK deriveCEKWrappingKey(D var1, Map<String, Object> var2);

    @Override
    public Set<String> getProcessedParameters() {
        return PROCESSED_PARAMETERS;
    }

    @Override
    protected WrappingJWAKeyManager.WrappedCEK doWrapCEK(OCTJWK cek, Map<String, Object> parameters, SecureRandom secureRandom) throws JWAKeyManagerException {
        DirectJWAKeyManager.DirectCEK derivedCEKWrappingKey = this.deriveCEKWrappingKey(this.algorithm, parameters);
        AESKWKeyManager aeskm = new AESKWKeyManager(derivedCEKWrappingKey.getEncryptionKey(), this.getCEKWrappingAlgorithm());
        WrappingJWAKeyManager.WrappedCEK wrappedCEK = aeskm.doWrapCEK(cek, parameters, secureRandom);
        HashMap<String, Object> mergedCustomParameters = new HashMap<String, Object>();
        if (derivedCEKWrappingKey.getMoreHeaderParameters() != null) {
            mergedCustomParameters.putAll(derivedCEKWrappingKey.getMoreHeaderParameters());
        }
        if (wrappedCEK.getMoreHeaderParameters() != null) {
            mergedCustomParameters.putAll(wrappedCEK.getMoreHeaderParameters());
        }
        return new GenericWrappedCEK(wrappedCEK.getWrappedKey(), mergedCustomParameters);
    }

    @Override
    protected OCTJWK doUnwrapCEK(byte[] encrypted_key, OCTAlgorithm octEnc, Map<String, Object> parameters) throws JWAKeyManagerException {
        DirectJWAKeyManager.DirectCEK derivedCEKWrappingKey = this.deriveCEKWrappingKey(this.algorithm, parameters);
        if (parameters != null && derivedCEKWrappingKey.getMoreHeaderParameters() != null) {
            parameters.putAll(derivedCEKWrappingKey.getMoreHeaderParameters());
        }
        AESKWKeyManager aeskm = new AESKWKeyManager(derivedCEKWrappingKey.getEncryptionKey(), this.getCEKWrappingAlgorithm());
        return aeskm.doUnwrapCEK(encrypted_key, octEnc, parameters);
    }
}

