/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwa.AbstractDirectJWAKeyManager;
import io.inverno.mod.security.jose.internal.jwa.GenericDirectCEK;
import io.inverno.mod.security.jose.internal.jwk.oct.GenericOCTJWK;
import io.inverno.mod.security.jose.jwa.DirectJWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAKeyManagerException;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwk.AsymmetricJWK;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.crypto.KeyAgreement;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractECDH_ESKeyManager<A extends PublicKey, B extends PrivateKey, C extends AsymmetricJWK<A, B>, D extends JWAAlgorithm<C>>
extends AbstractDirectJWAKeyManager<C, D> {
    public static final Set<String> PROCESSED_PARAMETERS = Set.of("epk", "apu", "apv");

    public AbstractECDH_ESKeyManager(C jwk, D algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
    }

    public AbstractECDH_ESKeyManager(C jwk) {
        super(jwk);
    }

    protected abstract String getKeyAgreementAlgorithm();

    protected abstract C getEPK(Map<String, Object> var1) throws JWAProcessingException;

    @Override
    public Set<String> getProcessedParameters() {
        return PROCESSED_PARAMETERS;
    }

    @Override
    public DirectJWAKeyManager.DirectCEK doDeriveCEK(OCTAlgorithm octEnc, Map<String, Object> parameters) throws JWAKeyManagerException {
        try {
            C epk = this.getEPK(parameters);
            KeyAgreement ka = KeyAgreement.getInstance(this.getKeyAgreementAlgorithm());
            Optional epkPrivateKey = epk.toPrivateKey();
            if (epkPrivateKey.isPresent()) {
                ka.init((Key)epkPrivateKey.get());
                ka.doPhase((Key)((AsymmetricJWK)this.jwk).toPublicKey(), true);
            } else {
                ka.init((Key)((AsymmetricJWK)this.jwk).toPrivateKey().orElseThrow(() -> new JWAKeyManagerException("JWK is missing private key")));
                ka.doPhase((Key)epk.toPublicKey(), true);
            }
            byte[] z = ka.generateSecret();
            byte[] deriveSharedKey = AbstractECDH_ESKeyManager.deriveSharedKey(z, octEnc, parameters);
            GenericOCTJWK cek = new GenericOCTJWK(JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(deriveSharedKey));
            cek.setAlgorithm(octEnc);
            return new GenericDirectCEK(cek, Map.of("epk", epk.toPublicJWK().minify()));
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new JWAKeyManagerException(e);
        }
    }

    private static byte[] deriveSharedKey(byte[] z, OCTAlgorithm encryptionAlgorithm, Map<String, Object> parameters) throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream dkmOutput = new ByteArrayOutputStream();
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] otherInfo = AbstractECDH_ESKeyManager.computeOtherInfo(encryptionAlgorithm.getAlgorithm(), encryptionAlgorithm.getEncryptionKeyLength(), parameters);
        int reps = (encryptionAlgorithm.getEncryptionKeyLength() + digest.getDigestLength() - 1) / digest.getDigestLength();
        for (int i = 1; i <= reps; ++i) {
            digest.update(JOSEUtils.toUnsignedBytes(i));
            digest.update(z);
            digest.update(otherInfo);
            dkmOutput.write(digest.digest());
        }
        byte[] dkm = dkmOutput.toByteArray();
        if (dkm.length == encryptionAlgorithm.getEncryptionKeyLength()) {
            return dkm;
        }
        byte[] sharedKey = new byte[encryptionAlgorithm.getEncryptionKeyLength()];
        System.arraycopy(dkm, 0, sharedKey, 0, sharedKey.length);
        return sharedKey;
    }

    private static byte[] computeOtherInfo(String enc, int keydatalen, Map<String, Object> parameters) throws JWAKeyManagerException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            AbstractECDH_ESKeyManager.appendOtherInfo(enc.getBytes(), dout);
            if (parameters != null) {
                String apu = (String)parameters.get("apu");
                if (!StringUtils.isBlank((CharSequence)apu)) {
                    AbstractECDH_ESKeyManager.appendOtherInfo(Base64.getUrlDecoder().decode(apu), dout);
                } else {
                    dout.writeInt(0);
                }
                String apv = (String)parameters.get("apv");
                if (!StringUtils.isBlank((CharSequence)apv)) {
                    AbstractECDH_ESKeyManager.appendOtherInfo(Base64.getUrlDecoder().decode(apv), dout);
                } else {
                    dout.writeInt(0);
                }
            } else {
                dout.writeInt(0);
                dout.writeInt(0);
            }
            dout.writeInt(keydatalen * 8);
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new JWAKeyManagerException("Error computing other info");
        }
    }

    private static void appendOtherInfo(byte[] otherInfo, DataOutputStream output) throws IOException {
        output.writeInt(otherInfo.length);
        output.write(otherInfo);
    }
}

