/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.jwa.AbstractJWAKeyManager;
import io.inverno.mod.security.jose.jwa.DirectJWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAKeyManagerException;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwk.JWK;
import java.util.Map;

public abstract class AbstractDirectJWAKeyManager<A extends JWK, B extends JWAAlgorithm<A>>
extends AbstractJWAKeyManager<A, B>
implements DirectJWAKeyManager {
    public AbstractDirectJWAKeyManager(A jwk, B algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
    }

    public AbstractDirectJWAKeyManager(A jwk) {
        super(jwk);
    }

    @Override
    public DirectJWAKeyManager.DirectCEK deriveCEK(String enc, Map<String, Object> parameters) throws JWAKeyManagerException {
        OCTAlgorithm octEnc;
        if (this.jwk.getKeyOperations() != null && !this.jwk.getKeyOperations().contains("deriveKey")) {
            throw new JWAKeyManagerException("JWK does not support derive key operations");
        }
        try {
            octEnc = OCTAlgorithm.fromAlgorithm(enc);
        }
        catch (IllegalArgumentException e) {
            throw new JWAKeyManagerException("Unsupported encryption algorithm: " + enc);
        }
        return this.doDeriveCEK(octEnc, parameters);
    }

    protected abstract DirectJWAKeyManager.DirectCEK doDeriveCEK(OCTAlgorithm var1, Map<String, Object> var2) throws JWAKeyManagerException;
}

