/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwa.AbstractWrappingJWAKeyManager;
import io.inverno.mod.security.jose.internal.jwa.GenericWrappedCEK;
import io.inverno.mod.security.jose.internal.jwk.oct.GenericOCTJWK;
import io.inverno.mod.security.jose.jwa.JWAKeyManagerException;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwa.WrappingJWAKeyManager;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class AESKWKeyManager
extends AbstractWrappingJWAKeyManager<OCTJWK, OCTAlgorithm> {
    public static final Set<OCTAlgorithm> SUPPORTED_ALGORITHMS = Set.of(OCTAlgorithm.A128KW, OCTAlgorithm.A192KW, OCTAlgorithm.A256KW);
    private SecretKey secretKey;

    public AESKWKeyManager(OCTJWK jwk, OCTAlgorithm algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
        if (!SUPPORTED_ALGORITHMS.contains(algorithm)) {
            throw new JWAProcessingException("Unsupported algorithm: " + algorithm.getAlgorithm());
        }
        this.init();
    }

    protected AESKWKeyManager(OCTJWK jwk) {
        super(jwk);
    }

    @Override
    protected final void init() throws JWAProcessingException {
        this.secretKey = ((OCTJWK)this.jwk).toSecretKey().orElseThrow(() -> new JWAProcessingException("JWK is missing secret key"));
        if (this.secretKey.getEncoded().length != ((OCTAlgorithm)this.algorithm).getEncryptionKeyLength()) {
            throw new JWAProcessingException("Key length " + this.secretKey.getEncoded().length + "does not match algorithm " + ((OCTAlgorithm)this.algorithm).getAlgorithm());
        }
    }

    @Override
    protected WrappingJWAKeyManager.WrappedCEK doWrapCEK(OCTJWK cek, Map<String, Object> parameters, SecureRandom secureRandom) throws JWAKeyManagerException {
        return cek.toSecretKey().map(cekSecretKey -> {
            try {
                Cipher cipher = Cipher.getInstance(((OCTAlgorithm)this.algorithm).getJcaAlgorithm());
                cipher.init(3, (Key)this.secretKey, secureRandom);
                byte[] encryptedKey = cipher.wrap((Key)cekSecretKey);
                return new GenericWrappedCEK(encryptedKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw new JWAKeyManagerException(e);
            }
        }).orElseThrow(() -> new JWAKeyManagerException("CEK secret key is missing"));
    }

    @Override
    protected OCTJWK doUnwrapCEK(byte[] encrypted_key, OCTAlgorithm octEnc, Map<String, Object> parameters) throws JWAKeyManagerException {
        try {
            Cipher cipher = Cipher.getInstance(((OCTAlgorithm)this.algorithm).getJcaAlgorithm());
            cipher.init(4, this.secretKey);
            SecretKey decryptedKey = (SecretKey)cipher.unwrap(encrypted_key, "AES", 3);
            GenericOCTJWK cek = new GenericOCTJWK(JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(decryptedKey.getEncoded()), decryptedKey, false);
            cek.setAlgorithm(octEnc);
            return cek;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new JWAKeyManagerException(e);
        }
    }
}

