/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwa.AbstractJWACipher;
import io.inverno.mod.security.jose.internal.jwa.GenericEncryptedData;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWACipherException;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public class AESGCMCipher
extends AbstractJWACipher {
    public static final Set<OCTAlgorithm> SUPPORTED_ALGORITHMS = Set.of(OCTAlgorithm.A128GCM, OCTAlgorithm.A192GCM, OCTAlgorithm.A256GCM);
    private SecretKey secretKey;

    public AESGCMCipher(OCTJWK jwk, OCTAlgorithm algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
        if (!SUPPORTED_ALGORITHMS.contains(algorithm)) {
            throw new JWAProcessingException("Unsupported algorithm: " + algorithm.getAlgorithm());
        }
        this.init();
    }

    protected AESGCMCipher(OCTJWK jwk) {
        super(jwk);
    }

    @Override
    protected final void init() throws JWAProcessingException {
        this.secretKey = this.jwk.toSecretKey().orElseThrow(() -> new JWAProcessingException("JWK is missing secret key"));
        if (this.secretKey.getEncoded().length != this.algorithm.getEncryptionKeyLength()) {
            throw new JWAProcessingException("Key length " + this.secretKey.getEncoded().length + "does not match algorithm " + this.algorithm.getAlgorithm());
        }
    }

    @Override
    protected JWACipher.EncryptedData doEncrypt(byte[] data, byte[] aad, SecureRandom secureRandom) throws JWACipherException {
        try {
            byte[] iv = JOSEUtils.generateInitializationVector(secureRandom, this.algorithm.getInitializationVectorLength());
            Cipher cipher = Cipher.getInstance(this.algorithm.getJcaAlgorithm());
            cipher.init(1, (Key)this.secretKey, new GCMParameterSpec(this.algorithm.getAuthenticationTagLength() * 8, iv), secureRandom);
            cipher.updateAAD(aad);
            byte[] encryptedData = cipher.doFinal(data);
            byte[] cipherText = new byte[encryptedData.length - this.algorithm.getAuthenticationTagLength()];
            byte[] authenticationTag = new byte[this.algorithm.getAuthenticationTagLength().intValue()];
            System.arraycopy(encryptedData, 0, cipherText, 0, cipherText.length);
            System.arraycopy(encryptedData, cipherText.length, authenticationTag, 0, authenticationTag.length);
            return new GenericEncryptedData(iv, cipherText, authenticationTag);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new JWACipherException(e);
        }
    }

    @Override
    protected byte[] doDecrypt(byte[] cipherText, byte[] aad, byte[] iv, byte[] tag) throws JWACipherException {
        if (iv.length != this.algorithm.getInitializationVectorLength()) {
            throw new JWACipherException("Initialization vector length " + iv.length + "does not match algorithm " + this.algorithm.getAlgorithm());
        }
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm.getJcaAlgorithm());
            cipher.init(2, (Key)this.secretKey, new GCMParameterSpec(this.algorithm.getAuthenticationTagLength() * 8, iv));
            cipher.updateAAD(aad);
            byte[] encryptedData = new byte[cipherText.length + tag.length];
            System.arraycopy(cipherText, 0, encryptedData, 0, cipherText.length);
            System.arraycopy(tag, 0, encryptedData, cipherText.length, tag.length);
            return cipher.doFinal(encryptedData);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new JWACipherException(e);
        }
    }
}

