/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.converter;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.converter.ConverterException;
import io.inverno.mod.base.converter.MediaTypeConverter;
import io.inverno.mod.security.jose.JOSEObject;
import io.inverno.mod.security.jose.internal.converter.JOSEMediaTypeConverter;
import io.inverno.mod.security.jose.jwe.JWE;
import io.inverno.mod.security.jose.jwe.JWEService;
import io.inverno.mod.security.jose.jws.JWS;
import io.inverno.mod.security.jose.jws.JWSService;
import io.inverno.mod.security.jose.jwt.JWTClaimsSet;
import io.inverno.mod.security.jose.jwt.JWTService;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Bean(name="jwtStringMediaTypeConverter")
public class JWTStringMediaTypeConverter
implements JOSEMediaTypeConverter,
MediaTypeConverter<String> {
    private JWTService jwtService;

    @Override
    public void injectJWSService(JWSService jwsService) {
    }

    @Override
    public void injectJWEService(JWEService jweService) {
    }

    @Override
    public void injectJWTService(JWTService jwtService) {
        this.jwtService = jwtService;
    }

    public boolean canConvert(String mediaType) {
        return mediaType.equalsIgnoreCase("application/jwt");
    }

    private void checkJWTType(Type type) throws ConverterException {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class && JWS.class.isAssignableFrom((Class)rawType) && JWE.class.isAssignableFrom((Class)rawType) && typeArguments.length == 1 && typeArguments[0] instanceof Class && JWTClaimsSet.class.isAssignableFrom((Class)typeArguments[0]))) {
                throw new ConverterException("Invalid JWT type: " + type.getTypeName());
            }
        } else if (!(type instanceof Class && JWS.class.isAssignableFrom((Class)type) && JWE.class.isAssignableFrom((Class)type))) {
            throw new ConverterException("Invalid JWT type: " + type.getTypeName());
        }
    }

    public <T> T decode(String value, Class<T> type) throws ConverterException {
        Objects.requireNonNull(value);
        this.checkJWTType(type);
        return (T)Flux.from(this.jwtService.readerFor(value, (Type)type).read(value)).next().block();
    }

    public <T> T decode(String value, Type type) throws ConverterException {
        return (T)this.decodeOne((Publisher<String>)Mono.just((Object)value), type).block();
    }

    public <T> Mono<T> decodeOne(Publisher<String> value, Class<T> type) {
        return this.decodeOne(value, (Type)type);
    }

    public <T> Mono<T> decodeOne(Publisher<String> value, Type type) {
        return Mono.fromRunnable(() -> this.checkJWTType(type)).then(Flux.from(value).reduceWith(() -> new StringBuilder(), (acc, v) -> acc.append((String)v)).map(StringBuilder::toString).flatMapMany(compact -> this.jwtService.readerFor((String)compact, type).read((String)compact)).next());
    }

    public <T> Flux<T> decodeMany(Publisher<String> value, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public <T> Flux<T> decodeMany(Publisher<String> value, Type type) {
        throw new UnsupportedOperationException();
    }

    public <T> String encode(T value) throws ConverterException {
        if (!(value instanceof JOSEObject)) {
            throw new ConverterException("Invalid JOSE object: " + value.getClass());
        }
        if (!(((JOSEObject)value).getPayload() instanceof JWTClaimsSet)) {
            throw new ConverterException("Invalid JWT payload: " + ((JOSEObject)value).getPayload().getClass());
        }
        return ((JOSEObject)value).toCompact();
    }

    public <T> String encode(T value, Class<T> type) throws ConverterException {
        return this.encode((Object)value);
    }

    public <T> String encode(T value, Type type) throws ConverterException {
        return this.encode((Object)value);
    }

    public <T> Publisher<String> encodeOne(Mono<T> value) {
        return value.map(jose -> {
            if (!(jose instanceof JOSEObject)) {
                throw new ConverterException("Invalid JOSE object: " + jose.getClass());
            }
            if (!(((JOSEObject)jose).getPayload() instanceof JWTClaimsSet)) {
                throw new ConverterException("Invalid JWT payload: " + ((JOSEObject)jose).getPayload().getClass());
            }
            return ((JOSEObject)jose).toCompact();
        });
    }

    public <T> Publisher<String> encodeOne(Mono<T> value, Class<T> type) {
        return this.encodeOne(value);
    }

    public <T> Publisher<String> encodeOne(Mono<T> value, Type type) {
        return this.encodeOne(value);
    }

    public <T> Publisher<String> encodeMany(Flux<T> value) {
        throw new UnsupportedOperationException();
    }

    public <T> Publisher<String> encodeMany(Flux<T> value, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public <T> Publisher<String> encodeMany(Flux<T> value, Type type) {
        throw new UnsupportedOperationException();
    }
}

