/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.converter;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.converter.ConverterException;
import io.inverno.mod.base.converter.MediaTypeConverter;
import io.inverno.mod.security.jose.JOSEObject;
import io.inverno.mod.security.jose.internal.converter.JOSEMediaTypeConverter;
import io.inverno.mod.security.jose.jwe.JWEService;
import io.inverno.mod.security.jose.jws.JWS;
import io.inverno.mod.security.jose.jws.JWSService;
import io.inverno.mod.security.jose.jwt.JWTService;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Bean(name="joseStringMediaTypeConverter")
public class JOSEStringMediaTypeConverter
implements JOSEMediaTypeConverter,
MediaTypeConverter<String> {
    private JWSService jwsService;
    private JWEService jweService;

    @Override
    public void injectJWSService(JWSService jwsService) {
        this.jwsService = jwsService;
    }

    @Override
    public void injectJWEService(JWEService jweService) {
        this.jweService = jweService;
    }

    @Override
    public void injectJWTService(JWTService jwtService) {
    }

    public boolean canConvert(String mediaType) {
        return mediaType.equalsIgnoreCase("application/jose");
    }

    public <T> T decode(String value, Class<T> type) throws ConverterException {
        return this.decode(value, (Type)type);
    }

    public <T> T decode(String value, Type type) throws ConverterException {
        return (T)this.decodeOne((Publisher<String>)Mono.just((Object)value), type).block();
    }

    public <T> Mono<T> decodeOne(Publisher<String> value, Class<T> type) {
        return this.decodeOne(value, (Type)type);
    }

    public <T> Mono<T> decodeOne(Publisher<String> value, Type type) {
        return Flux.from(value).reduceWith(() -> new StringBuilder(), (acc, v) -> acc.append((String)v)).map(StringBuilder::toString).flatMap(compact -> {
            String[] splitCompact = compact.split("\\.");
            switch (splitCompact.length) {
                case 3: {
                    if (this.jwsService != null) {
                        return this.jwsService.reader(this.getJosePayloadType(type, JWS.class)).read((String)compact);
                    }
                    throw new ConverterException("Missing JWS service, unable to decode JWS");
                }
                case 5: {
                    if (this.jweService != null) {
                        return this.jweService.reader(this.getJosePayloadType(type, JWS.class)).read((String)compact);
                    }
                    throw new ConverterException("Missing JWE service, unable to decode JWE");
                }
            }
            throw new ConverterException("Invalid JOSE object compact representation");
        });
    }

    private Type getJosePayloadType(Type type, Class<?> joseRawType) throws ConverterException {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class && joseRawType.isAssignableFrom((Class)rawType)) {
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                if (typeArguments.length == 0) {
                    return Object.class;
                }
                return typeArguments[0];
            }
            throw new ConverterException("Invalid Jose object type");
        }
        if (type instanceof Class && joseRawType.isAssignableFrom((Class)type)) {
            return Object.class;
        }
        throw new ConverterException("Invalid Jose object type");
    }

    public <T> Flux<T> decodeMany(Publisher<String> value, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public <T> Flux<T> decodeMany(Publisher<String> value, Type type) {
        throw new UnsupportedOperationException();
    }

    public <T> String encode(T value) throws ConverterException {
        if (value instanceof JOSEObject) {
            return ((JOSEObject)value).toCompact();
        }
        throw new ConverterException("Invalid JOSE object: " + value.getClass());
    }

    public <T> String encode(T value, Class<T> type) throws ConverterException {
        return this.encode((Object)value);
    }

    public <T> String encode(T value, Type type) throws ConverterException {
        return this.encode((Object)value);
    }

    public <T> Publisher<String> encodeOne(Mono<T> value) {
        return value.map(jose -> {
            if (jose instanceof JOSEObject) {
                return ((JOSEObject)jose).toCompact();
            }
            throw new ConverterException("Invalid JOSE object: " + jose.getClass());
        });
    }

    public <T> Publisher<String> encodeOne(Mono<T> value, Class<T> type) {
        return this.encodeOne(value);
    }

    public <T> Publisher<String> encodeOne(Mono<T> value, Type type) {
        return this.encodeOne(value);
    }

    public <T> Publisher<String> encodeMany(Flux<T> value) {
        throw new UnsupportedOperationException();
    }

    public <T> Publisher<String> encodeMany(Flux<T> value, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public <T> Publisher<String> encodeMany(Flux<T> value, Type type) {
        throw new UnsupportedOperationException();
    }
}

