/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.converter;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.converter.ConverterException;
import io.inverno.mod.base.converter.MediaTypeConverter;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.JsonJOSEObject;
import io.inverno.mod.security.jose.internal.converter.JOSEMediaTypeConverter;
import io.inverno.mod.security.jose.jwe.JWEService;
import io.inverno.mod.security.jose.jwe.JsonJWE;
import io.inverno.mod.security.jose.jws.JWSService;
import io.inverno.mod.security.jose.jws.JsonJWS;
import io.inverno.mod.security.jose.jwt.JWTService;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Bean(name="joseJsonStringMediaTypeConverter")
public class JOSEJsonStringMediaTypeConverter
implements JOSEMediaTypeConverter,
MediaTypeConverter<String> {
    private JWSService jwsService;
    private JWEService jweService;

    @Override
    public void injectJWSService(JWSService jwsService) {
        this.jwsService = jwsService;
    }

    @Override
    public void injectJWEService(JWEService jweService) {
        this.jweService = jweService;
    }

    @Override
    public void injectJWTService(JWTService jwtService) {
    }

    public boolean canConvert(String mediaType) {
        return mediaType.equalsIgnoreCase("application/jose+json");
    }

    public <T> T decode(String value, Class<T> type) throws ConverterException {
        return this.decode(value, (Type)type);
    }

    public <T> T decode(String value, Type type) throws ConverterException {
        return (T)this.decodeOne((Publisher<String>)Mono.just((Object)value), type).block();
    }

    public <T> Mono<T> decodeOne(Publisher<String> value, Class<T> type) {
        return this.decodeOne(value, (Type)type);
    }

    public <T> Mono<T> decodeOne(Publisher<String> value, Type type) {
        return Flux.from(value).reduceWith(() -> new StringBuilder(), (acc, v) -> acc.append((String)v)).map(StringBuilder::toString).flatMap(joseJson -> {
            Exception jweError;
            Exception jwsError;
            if (this.jwsService != null) {
                try {
                    return this.jwsService.jsonReader(this.getJosePayloadType(type, JsonJWS.class)).read((String)joseJson);
                }
                catch (Exception e) {
                    jwsError = e;
                }
            } else {
                jwsError = new JOSEProcessingException("Missing JWS service, unable to decode JWS");
            }
            if (this.jweService != null) {
                try {
                    return this.jweService.jsonReader(this.getJosePayloadType(type, JsonJWE.class)).read((String)joseJson);
                }
                catch (Exception e) {
                    jweError = e;
                }
            } else {
                jweError = new JOSEProcessingException("Missing JWE service, unable to decode JWE");
            }
            ConverterException error = new ConverterException();
            error.addSuppressed((Throwable)jwsError);
            error.addSuppressed((Throwable)jweError);
            throw error;
        });
    }

    private Type getJosePayloadType(Type type, Class<?> joseRawType) throws ConverterException {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class && joseRawType.isAssignableFrom((Class)rawType)) {
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                if (typeArguments.length == 0) {
                    return Object.class;
                }
                return typeArguments[0];
            }
            throw new ConverterException("Invalid Jose object type");
        }
        if (type instanceof Class && joseRawType.isAssignableFrom((Class)type)) {
            return Object.class;
        }
        throw new ConverterException("Invalid Jose object type");
    }

    public <T> Flux<T> decodeMany(Publisher<String> value, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public <T> Flux<T> decodeMany(Publisher<String> value, Type type) {
        throw new UnsupportedOperationException();
    }

    public <T> String encode(T value) throws ConverterException {
        if (value instanceof JsonJOSEObject) {
            return ((JsonJOSEObject)value).toJson();
        }
        throw new ConverterException("Invalid Json JOSE object: " + value.getClass());
    }

    public <T> String encode(T value, Class<T> type) throws ConverterException {
        return this.encode((Object)value);
    }

    public <T> String encode(T value, Type type) throws ConverterException {
        return this.encode((Object)value);
    }

    public <T> Publisher<String> encodeOne(Mono<T> value) {
        return value.map(jose -> {
            if (jose instanceof JsonJOSEObject) {
                return ((JsonJOSEObject)jose).toJson();
            }
            throw new ConverterException("Invalid Json JOSE object: " + jose.getClass());
        });
    }

    public <T> Publisher<String> encodeOne(Mono<T> value, Class<T> type) {
        return this.encodeOne(value);
    }

    public <T> Publisher<String> encodeOne(Mono<T> value, Type type) {
        return this.encodeOne(value);
    }

    public <T> Publisher<String> encodeMany(Flux<T> value) {
        throw new UnsupportedOperationException();
    }

    public <T> Publisher<String> encodeMany(Flux<T> value, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public <T> Publisher<String> encodeMany(Flux<T> value, Type type) {
        throw new UnsupportedOperationException();
    }
}

