/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal;

import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;

public class JOSEUtils {
    public static final SecureRandom DEFAULT_SECURE_RANDOM = new SecureRandom();
    public static final Base64.Encoder BASE64_NOPAD_URL_ENCODER = Base64.getUrlEncoder().withoutPadding();

    public static byte[] toPaddedUnsignedBytes(BigInteger value, int length) throws JWKProcessingException {
        byte[] bytes = value.toByteArray();
        if (bytes.length == length) {
            return bytes;
        }
        int start = bytes[0] == 0 && bytes.length != 1 ? 1 : 0;
        int count = bytes.length - start;
        if (count > length) {
            throw new JWKProcessingException("standard length exceeded for value");
        }
        byte[] paddedBytes = new byte[length];
        System.arraycopy(bytes, start, paddedBytes, paddedBytes.length - count, count);
        return paddedBytes;
    }

    public static byte[] toUnsignedBytes(BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0 && bytes.length != 1) {
            byte[] tmp = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, tmp, 0, tmp.length);
            return tmp;
        }
        return bytes;
    }

    public static byte[] toUnsignedBytes(int value) {
        return new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public static byte[] generateInitializationVector(SecureRandom secureRandom, int length) {
        byte[] iv = new byte[length];
        secureRandom.nextBytes(iv);
        return iv;
    }

    public static byte[] generateSalt(SecureRandom secureRandom, int length) {
        byte[] salt = new byte[length];
        secureRandom.nextBytes(salt);
        return salt;
    }

    public static String toX509CertificateSha1Thumbprint(X509Certificate certificate) throws JWKProcessingException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = certificate.getEncoded();
            md.update(der);
            return BASE64_NOPAD_URL_ENCODER.encodeToString(md.digest());
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new JWKProcessingException("Error generating X509 certificate thumbprint", e);
        }
    }

    public static String toX509CertificateSha256Thumbprint(X509Certificate certificate) throws JWKProcessingException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] der = certificate.getEncoded();
            md.update(der);
            return BASE64_NOPAD_URL_ENCODER.encodeToString(md.digest());
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new JWKProcessingException("Error generating X509 certificate thumbprint", e);
        }
    }
}

