/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.base.converter.MediaTypeConverter;
import io.inverno.mod.base.resource.MediaTypes;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.JsonJOSEObject;
import io.inverno.mod.security.jose.JsonJOSEObjectReader;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.jwk.JWKService;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class AbstractJsonJOSEObjectReader<A, B extends JsonJOSEObject<A>, C extends AbstractJsonJOSEObjectReader<A, B, C>>
implements JsonJOSEObjectReader<A, B, C> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractJsonJOSEObjectReader.class);
    protected final ObjectMapper mapper;
    protected final DataConversionService dataConversionService;
    protected final JWKService jwkService;
    protected final Type type;
    protected Set<String> applicationProcessedParameters;

    public AbstractJsonJOSEObjectReader(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type) {
        this.mapper = mapper;
        this.dataConversionService = dataConversionService;
        this.jwkService = jwkService;
        this.type = type;
    }

    @Override
    public C processedParameters(String ... parameters) {
        this.applicationProcessedParameters = parameters == null || parameters.length == 0 ? null : Arrays.stream(parameters).filter(Objects::nonNull).collect(Collectors.toSet());
        return (C)this;
    }

    protected Function<String, Mono<A>> getPayloadDecoder(Function<String, Mono<A>> overridingPayloadDecoder, String overridingContentType, String cty) throws JOSEObjectReadException, JOSEProcessingException {
        String resolvedContentType;
        if (overridingPayloadDecoder != null) {
            return overridingPayloadDecoder;
        }
        if (StringUtils.isNotBlank((CharSequence)overridingContentType)) {
            if (LOGGER.isDebugEnabled() && StringUtils.isNotBlank((CharSequence)cty) && MediaTypes.normalizeApplicationMediaType((String)cty).equals(MediaTypes.normalizeApplicationMediaType((String)overridingContentType))) {
                LOGGER.debug("The overriding content type differs from the JOSE header content type");
            }
            resolvedContentType = overridingContentType;
        } else if (StringUtils.isNotBlank((CharSequence)cty)) {
            resolvedContentType = cty;
        } else {
            throw new JOSEObjectReadException("Content type is blank and no overriding content type was provided");
        }
        MediaTypeConverter<String> payloadConverter = this.dataConversionService.getConverter(resolvedContentType).orElseThrow(() -> new JOSEObjectReadException("No converter found for content type: " + resolvedContentType));
        return payloadRaw -> payloadConverter.decodeOne((Publisher)Mono.just((Object)payloadRaw), this.type);
    }
}

