/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.base.converter.MediaTypeConverter;
import io.inverno.mod.base.resource.MediaTypes;
import io.inverno.mod.security.jose.JOSEHeaderConfigurator;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.JsonJOSEObject;
import io.inverno.mod.security.jose.JsonJOSEObjectBuilder;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.jwk.JWKService;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractJsonJOSEObjectBuilder<A, B extends JsonJOSEObject<A>, C extends JOSEHeaderConfigurator<C>, D extends AbstractJsonJOSEObjectBuilder<A, B, C, D>>
implements JsonJOSEObjectBuilder<A, B, C, D> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractJsonJOSEObjectBuilder.class);
    protected final ObjectMapper mapper;
    protected final DataConversionService dataConversionService;
    protected final JWKService jwkService;
    protected final Type type;
    protected Consumer<C> protectedHeaderConfigurer;
    protected Consumer<C> unprotectedHeaderConfigurer;
    protected A payload;

    public AbstractJsonJOSEObjectBuilder(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type) {
        this.mapper = mapper;
        this.dataConversionService = dataConversionService;
        this.jwkService = jwkService;
        this.type = type;
    }

    @Override
    public D headers(Consumer<C> protectedHeaderConfigurer, Consumer<C> unprotectedHeaderConfigurer) {
        this.protectedHeaderConfigurer = protectedHeaderConfigurer;
        this.unprotectedHeaderConfigurer = unprotectedHeaderConfigurer;
        return (D)this;
    }

    @Override
    public D payload(A payload) {
        this.payload = payload;
        return (D)this;
    }

    protected void checkPayload() throws JOSEObjectBuildException, JOSEProcessingException {
        if (this.payload == null) {
            throw new JOSEObjectBuildException("Payload is null");
        }
    }

    protected Function<A, Mono<String>> getPayloadEncoder(Function<A, Mono<String>> overridingPayloadEncoder, String overridingContentType, String cty) throws JOSEObjectBuildException, JOSEProcessingException {
        String resolvedContentType;
        if (overridingPayloadEncoder != null) {
            return overridingPayloadEncoder;
        }
        if (StringUtils.isNotBlank((CharSequence)overridingContentType)) {
            if (LOGGER.isDebugEnabled() && StringUtils.isNotBlank((CharSequence)cty) && MediaTypes.normalizeApplicationMediaType((String)cty).equals(overridingContentType)) {
                LOGGER.debug("The overriding content type differs from the JOSE header content type");
            }
            resolvedContentType = overridingContentType;
        } else if (StringUtils.isNotBlank((CharSequence)cty)) {
            resolvedContentType = cty;
        } else {
            throw new JOSEObjectBuildException("Content type is blank and no overriding content type was provided");
        }
        MediaTypeConverter<String> payloadConverter = this.dataConversionService.getConverter(resolvedContentType).orElseThrow(() -> new JOSEObjectBuildException("No converter found for content type: " + resolvedContentType));
        if (this.type != null) {
            return p -> Flux.from((Publisher)payloadConverter.encodeOne(Mono.just((Object)p), this.type)).reduceWith(() -> new StringBuilder(), (acc, v) -> acc.append((String)v)).map(StringBuilder::toString);
        }
        return p -> Flux.from((Publisher)payloadConverter.encodeOne(Mono.just((Object)p))).reduceWith(() -> new StringBuilder(), (acc, v) -> acc.append((String)v)).map(StringBuilder::toString);
    }
}

