/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.base.converter.MediaTypeConverter;
import io.inverno.mod.base.resource.MediaTypes;
import io.inverno.mod.security.jose.JOSEHeader;
import io.inverno.mod.security.jose.JOSEObject;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEObjectReader;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.AbstractJOSEHeader;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.jwa.JWA;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractJOSEObjectReader<A, B extends JOSEHeader, C extends JOSEObject<A, B>, D extends AbstractJOSEObjectReader<A, B, C, D>>
implements JOSEObjectReader<A, B, C, D> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractJOSEObjectReader.class);
    protected final ObjectMapper mapper;
    protected final DataConversionService dataConversionService;
    protected final JWKService jwkService;
    protected final Type type;
    protected final Publisher<? extends JWK> keys;
    protected Set<String> applicationProcessedParameters;

    public AbstractJOSEObjectReader(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys) {
        this.mapper = mapper;
        this.dataConversionService = dataConversionService;
        this.jwkService = jwkService;
        this.type = type;
        this.keys = keys;
    }

    @Override
    public D processedParameters(String ... parameters) {
        this.applicationProcessedParameters = parameters == null || parameters.length == 0 ? null : Arrays.stream(parameters).filter(Objects::nonNull).collect(Collectors.toSet());
        return (D)this;
    }

    protected Set<String> getProcessedParameters() {
        return AbstractJOSEHeader.PROCESSED_PARAMETERS;
    }

    protected Flux<? extends JWK> getKeys(JOSEHeader header) throws JOSEObjectReadException {
        if (this.keys != null) {
            return Flux.from(this.keys).filter(key -> {
                if (!key.supportsAlgorithm(header.getAlgorithm())) {
                    LOGGER.debug(() -> "Ignoring key " + key + " which does not support algorithm " + header.getAlgorithm());
                    return false;
                }
                return true;
            }).switchIfEmpty((Publisher)Mono.error(() -> new JOSEObjectReadException("No suitable key found")));
        }
        return Flux.from(this.jwkService.read(header)).filter(key -> {
            if (!key.isTrusted()) {
                LOGGER.debug(() -> "Skipping untrusted key: " + key);
                return false;
            }
            return true;
        }).switchIfEmpty((Publisher)Mono.error(() -> new JOSEObjectReadException("No suitable key found")));
    }

    protected void checkHeader(B header) throws JOSEObjectReadException, JOSEProcessingException {
        if (StringUtils.isBlank((CharSequence)header.getAlgorithm())) {
            throw new JOSEObjectReadException("Algorithm is blank");
        }
        if (header.getCritical() != null) {
            Set<String> processedParameters;
            HashSet<String> remainingCrit = new HashSet<String>(header.getCritical());
            if (remainingCrit.removeAll(processedParameters = this.getProcessedParameters())) {
                throw new JOSEObjectReadException("Critical parameters must not include registered parameters: " + header.getCritical().stream().filter(processedParameters::contains).collect(Collectors.joining(", ")));
            }
            remainingCrit.removeAll(header.getCustomParameters().keySet());
            if (!remainingCrit.isEmpty()) {
                throw new JOSEObjectReadException("Critical parameters must not include parameters not defined as custom parameters: " + remainingCrit.stream().collect(Collectors.joining(", ")));
            }
        }
    }

    protected void checkCriticalParameters(Set<String> crit, JWA ... jwas) throws JOSEObjectReadException, JOSEProcessingException {
        if (crit != null) {
            HashSet<String> remainingParameters = new HashSet<String>(crit);
            if (jwas != null) {
                for (JWA jwa : jwas) {
                    if (jwa == null) continue;
                    remainingParameters.removeAll(jwa.getProcessedParameters());
                }
            }
            if (this.applicationProcessedParameters != null) {
                remainingParameters.removeAll(this.applicationProcessedParameters);
            }
            if (!remainingParameters.isEmpty()) {
                throw new JOSEObjectReadException("Unsupported critical parameters: " + remainingParameters.stream().collect(Collectors.joining(", ")));
            }
        }
    }

    protected Function<String, Mono<A>> getPayloadDecoder(Function<String, Mono<A>> overridingPayloadDecoder, String overridingContentType, JOSEHeader header) throws JOSEObjectReadException, JOSEProcessingException {
        String resolvedContentType;
        if (overridingPayloadDecoder != null) {
            return overridingPayloadDecoder;
        }
        String cty = header.getContentType();
        if (StringUtils.isNotBlank((CharSequence)overridingContentType)) {
            if (LOGGER.isDebugEnabled() && StringUtils.isNotBlank((CharSequence)cty) && MediaTypes.normalizeApplicationMediaType((String)cty).equals(MediaTypes.normalizeApplicationMediaType((String)overridingContentType))) {
                LOGGER.debug("The overriding content type differs from the JOSE header content type");
            }
            resolvedContentType = overridingContentType;
        } else if (StringUtils.isNotBlank((CharSequence)cty)) {
            resolvedContentType = cty;
        } else {
            throw new JOSEObjectReadException("Content type is blank and no overriding content type was provided");
        }
        MediaTypeConverter<String> payloadConverter = this.dataConversionService.getConverter(resolvedContentType).orElseThrow(() -> new JOSEObjectReadException("No converter found for content type: " + resolvedContentType));
        return payloadRaw -> payloadConverter.decodeOne((Publisher)Mono.just((Object)payloadRaw), this.type);
    }
}

