/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.base.converter.MediaTypeConverter;
import io.inverno.mod.base.resource.MediaTypes;
import io.inverno.mod.security.jose.JOSEHeader;
import io.inverno.mod.security.jose.JOSEHeaderConfigurator;
import io.inverno.mod.security.jose.JOSEObject;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEObjectBuilder;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.AbstractJOSEHeader;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractJOSEObjectBuilder<A, B extends JOSEHeader, C extends JOSEObject<A, B>, D extends JOSEHeaderConfigurator<D>, E extends AbstractJOSEObjectBuilder<A, B, C, D, E>>
implements JOSEObjectBuilder<A, B, C, D, E> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractJOSEObjectBuilder.class);
    protected final ObjectMapper mapper;
    protected final DataConversionService dataConversionService;
    protected final JWKService jwkService;
    protected final Type type;
    protected final Publisher<? extends JWK> keys;
    protected A payload;

    public AbstractJOSEObjectBuilder(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys) {
        this.mapper = mapper;
        this.dataConversionService = dataConversionService;
        this.jwkService = jwkService;
        this.type = type;
        this.keys = keys;
    }

    @Override
    public E payload(A payload) {
        this.payload = payload;
        return (E)this;
    }

    protected Set<String> getProcessedParameters() {
        return AbstractJOSEHeader.PROCESSED_PARAMETERS;
    }

    protected Flux<? extends JWK> getKeys(JOSEHeader header) throws JOSEObjectBuildException {
        if (this.keys != null) {
            return Flux.from(this.keys).filter(key -> {
                if (!key.supportsAlgorithm(header.getAlgorithm())) {
                    LOGGER.warn(() -> "Ignoring key " + key + " which does not support algorithm " + header.getAlgorithm());
                    return false;
                }
                return true;
            }).switchIfEmpty((Publisher)Mono.error(() -> new JOSEObjectBuildException("No suitable key found")));
        }
        return Flux.from(this.jwkService.read(header)).filter(key -> {
            if (!key.isTrusted()) {
                LOGGER.warn(() -> "Skipping untrusted key: " + key);
                return false;
            }
            return true;
        }).switchIfEmpty((Publisher)Mono.error(() -> new JOSEObjectBuildException("No suitable key found")));
    }

    protected void checkHeader(B header) throws JOSEObjectBuildException, JOSEProcessingException {
        if (StringUtils.isBlank((CharSequence)header.getAlgorithm())) {
            throw new JOSEObjectBuildException("Algorithm is blank");
        }
        Map<String, Object> customParameters = header.getCustomParameters();
        if (customParameters != null) {
            HashSet<String> invalidCustomParameters = new HashSet<String>(customParameters.keySet());
            invalidCustomParameters.retainAll(this.getProcessedParameters());
            if (!invalidCustomParameters.isEmpty()) {
                throw new JOSEObjectBuildException("Custom parameters must not include registered parameters: " + invalidCustomParameters.stream().collect(Collectors.joining(", ")));
            }
        }
        if (header.getCritical() != null) {
            HashSet<String> remainingCrit = new HashSet<String>(header.getCritical());
            if (customParameters != null) {
                remainingCrit.removeAll(customParameters.keySet());
            }
            if (!remainingCrit.isEmpty()) {
                throw new JOSEObjectBuildException("Critical parameters must not include parameters not defined as custom parameters: " + remainingCrit.stream().collect(Collectors.joining(", ")));
            }
        }
    }

    protected void checkPayload() throws JOSEObjectBuildException, JOSEProcessingException {
        if (this.payload == null) {
            throw new JOSEObjectBuildException("Payload is null");
        }
    }

    protected Function<A, Mono<String>> getPayloadEncoder(Function<A, Mono<String>> overridingPayloadEncoder, String overridingContentType, JOSEHeader header) throws JOSEObjectBuildException, JOSEProcessingException {
        String resolvedContentType;
        if (overridingPayloadEncoder != null) {
            return overridingPayloadEncoder;
        }
        String cty = header.getContentType();
        if (StringUtils.isNotBlank((CharSequence)overridingContentType)) {
            if (LOGGER.isDebugEnabled() && StringUtils.isNotBlank((CharSequence)cty) && MediaTypes.normalizeApplicationMediaType((String)cty).equals(MediaTypes.normalizeApplicationMediaType((String)overridingContentType))) {
                LOGGER.debug("The overriding content type differs from the JOSE header content type");
            }
            resolvedContentType = overridingContentType;
        } else if (StringUtils.isNotBlank((CharSequence)cty)) {
            resolvedContentType = cty;
        } else {
            throw new JOSEObjectBuildException("Content type is blank and no overriding content type was provided");
        }
        MediaTypeConverter<String> payloadConverter = this.dataConversionService.getConverter(resolvedContentType).orElseThrow(() -> new JOSEObjectBuildException("No converter found for content type: " + resolvedContentType));
        if (this.type != null) {
            return p -> Flux.from((Publisher)payloadConverter.encodeOne(Mono.just((Object)p), this.type)).reduceWith(() -> new StringBuilder(), (acc, v) -> acc.append((String)v)).map(StringBuilder::toString);
        }
        return p -> Flux.from((Publisher)payloadConverter.encodeOne(Mono.just((Object)p))).reduceWith(() -> new StringBuilder(), (acc, v) -> acc.append((String)v)).map(StringBuilder::toString);
    }
}

