/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal;

import io.inverno.mod.security.jose.JOSEHeader;
import io.inverno.mod.security.jose.JOSEObject;
import io.inverno.mod.security.jose.internal.AbstractJOSEPayload;
import java.util.Objects;

public abstract class AbstractJOSEObject<A, B extends JOSEHeader, C extends AbstractJOSEPayload<A>>
implements JOSEObject<A, B> {
    protected final B header;
    protected final C payload;

    public AbstractJOSEObject(B header, C payload) {
        this.header = header;
        this.payload = payload;
    }

    @Override
    public B getHeader() {
        return this.header;
    }

    @Override
    public A getPayload() {
        return ((AbstractJOSEPayload)this.payload).getValue();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.header, this.payload);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractJOSEObject other = (AbstractJOSEObject)obj;
        return Objects.equals(this.header, other.header) && Objects.equals(this.payload, other.payload);
    }
}

