/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.inverno.mod.security.jose.JOSEHeader;
import io.inverno.mod.security.jose.JOSEHeaderConfigurator;
import io.inverno.mod.security.jose.jwk.JWK;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractJOSEHeader<A extends AbstractJOSEHeader<A>>
implements JOSEHeader,
JOSEHeaderConfigurator<A> {
    public static final Set<String> PROCESSED_PARAMETERS = Set.of("alg", "jku", "jwk", "kid", "x5u", "x5c", "x5t", "x5t#S256", "typ", "cty", "crit");
    protected String alg;
    protected URI jku;
    protected Map<String, Object> jwk;
    protected String kid;
    protected URI x5u;
    protected String[] x5c;
    protected String x5t;
    protected String x5t_S256;
    protected String typ;
    protected String cty;
    protected Set<String> crit;
    protected Map<String, Object> customParameters;
    protected String encoded;
    protected JWK key;

    public AbstractJOSEHeader() {
    }

    public AbstractJOSEHeader(String alg) {
        this.alg = alg;
    }

    public void setEncoded(String encoded) {
        this.encoded = encoded;
    }

    @Override
    @JsonIgnore
    public String getEncoded() {
        return this.encoded;
    }

    @JsonIgnore
    public Set<String> getProcessedParameters() {
        return PROCESSED_PARAMETERS;
    }

    @Override
    public String getAlgorithm() {
        return this.alg;
    }

    @Override
    public URI getJWKSetURL() {
        return this.jku;
    }

    @Override
    public Map<String, Object> getJWK() {
        return this.jwk;
    }

    @Override
    public String getKeyId() {
        return this.kid;
    }

    @Override
    public URI getX509CertificateURL() {
        return this.x5u;
    }

    @Override
    public String[] getX509CertificateChain() {
        return this.x5c;
    }

    @Override
    public String getX509CertificateSHA1Thumbprint() {
        return this.x5t;
    }

    @Override
    public String getX509CertificateSHA256Thumbprint() {
        return this.x5t_S256;
    }

    @Override
    public String getType() {
        return this.typ;
    }

    @Override
    public String getContentType() {
        return this.cty;
    }

    @Override
    public Set<String> getCritical() {
        return this.crit;
    }

    @Override
    public Map<String, Object> getCustomParameters() {
        return this.customParameters;
    }

    public void setKey(JWK key) {
        this.key = key;
    }

    @Override
    public JWK getKey() {
        return this.key;
    }

    @Override
    @JsonSetter(value="alg")
    public A algorithm(String alg) {
        this.alg = alg;
        return (A)this;
    }

    @Override
    @JsonSetter(value="jku")
    public A jwkSetURL(URI jku) {
        this.jku = jku;
        return (A)this;
    }

    @Override
    @JsonSetter(value="jwk")
    public A jwk(Map<String, Object> jwk) {
        this.jwk = jwk;
        return (A)this;
    }

    @Override
    @JsonSetter(value="kid")
    public A keyId(String kid) {
        this.kid = kid;
        return (A)this;
    }

    @Override
    @JsonSetter(value="x5u")
    public A x509CertificateURL(URI x5u) {
        this.x5u = x5u;
        return (A)this;
    }

    @Override
    @JsonSetter(value="x5c")
    public A x509CertificateChain(String[] x5c) {
        this.x5c = x5c;
        return (A)this;
    }

    @Override
    @JsonSetter(value="x5t")
    public A x509CertificateSHA1Thumbprint(String x5t) {
        this.x5t = x5t;
        return (A)this;
    }

    @Override
    @JsonSetter(value="x5t#S256")
    public A x509CertificateSHA256Thumbprint(String x5t_S256) {
        this.x5t_S256 = x5t_S256;
        return (A)this;
    }

    @Override
    @JsonSetter(value="typ")
    public A type(String typ) {
        this.typ = typ;
        return (A)this;
    }

    @Override
    @JsonSetter(value="cty")
    public A contentType(String cty) {
        this.cty = cty;
        return (A)this;
    }

    @Override
    @JsonSetter(value="crit")
    public A critical(String ... crit) {
        if (crit == null) {
            this.crit = null;
        } else {
            if (crit.length == 0) {
                throw new IllegalArgumentException("Critical parameters must not be the empty list");
            }
            List<String> critList = Arrays.asList(crit);
            this.crit = new HashSet<String>(critList);
            if (this.crit.size() != critList.size()) {
                throw new IllegalArgumentException("Critical parameters must not contain duplicates: " + critList.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(", ")));
            }
        }
        return (A)this;
    }

    @Override
    @JsonAnySetter
    public A addCustomParameter(String key, Object value) {
        if (value != null) {
            if (this.customParameters == null) {
                this.customParameters = new HashMap<String, Object>();
            }
            this.customParameters.put(key, value);
        }
        return (A)this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.x5c);
        result = 31 * result + Objects.hash(this.alg, this.crit, this.cty, this.customParameters, this.jku, this.jwk, this.kid, this.typ, this.x5t, this.x5t_S256, this.x5u);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractJOSEHeader other = (AbstractJOSEHeader)obj;
        return Objects.equals(this.alg, other.alg) && Objects.equals(this.crit, other.crit) && Objects.equals(this.cty, other.cty) && Objects.equals(this.customParameters, other.customParameters) && Objects.equals(this.jku, other.jku) && Objects.equals(this.jwk, other.jwk) && Objects.equals(this.kid, other.kid) && Objects.equals(this.typ, other.typ) && Arrays.equals(this.x5c, other.x5c) && Objects.equals(this.x5t, other.x5t) && Objects.equals(this.x5t_S256, other.x5t_S256) && Objects.equals(this.x5u, other.x5u);
    }
}

